/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.util.Assert;

class InstanceCreatorMetadataSupport<T, P extends PersistentProperty<P>>
implements InstanceCreatorMetadata<P> {
    private final Executable executable;
    private final List<Parameter<Object, P>> parameters;
    private volatile Map<PersistentProperty<?>, Boolean> isPropertyParameterCache = new HashMap();

    @SafeVarargs
    public InstanceCreatorMetadataSupport(Executable executable, Parameter<Object, P> ... parameters) {
        Assert.notNull((Object)executable, "Executable must not be null");
        Assert.notNull(parameters, "Parameters must not be null");
        this.executable = executable;
        this.parameters = Arrays.asList(parameters);
    }

    Executable getExecutable() {
        return this.executable;
    }

    @Override
    public List<Parameter<Object, P>> getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCreatorParameter(PersistentProperty<?> property) {
        Assert.notNull(property, "Property must not be null");
        Boolean cached = this.isPropertyParameterCache.get(property);
        if (cached == null) {
            InstanceCreatorMetadataSupport instanceCreatorMetadataSupport = this;
            synchronized (instanceCreatorMetadataSupport) {
                Boolean fromCache = this.isPropertyParameterCache.get(property);
                if (fromCache != null) {
                    cached = fromCache;
                } else {
                    cached = this.doGetIsCreatorParameter(property);
                    HashMap isPropertyParameterCache = new HashMap(this.isPropertyParameterCache);
                    isPropertyParameterCache.put(property, cached);
                    this.isPropertyParameterCache = isPropertyParameterCache;
                }
            }
        }
        return cached;
    }

    public String toString() {
        return this.executable.toString();
    }

    private boolean doGetIsCreatorParameter(PersistentProperty<?> property) {
        for (Parameter<Object, P> parameter : this.parameters) {
            if (!parameter.maps(property)) continue;
            return true;
        }
        return false;
    }
}

