/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class DefaultPersistentPropertyPath<P extends PersistentProperty<P>>
implements PersistentPropertyPath<P> {
    private static final Converter<PersistentProperty<?>, String> DEFAULT_CONVERTER = PersistentProperty::getName;
    private static final String DEFAULT_DELIMITER = ".";
    private final List<P> properties;

    public DefaultPersistentPropertyPath(List<P> properties) {
        Assert.notNull(properties, "Properties must not be null");
        this.properties = properties;
    }

    static <T extends PersistentProperty<T>> DefaultPersistentPropertyPath<T> empty() {
        return new DefaultPersistentPropertyPath(Collections.emptyList());
    }

    DefaultPersistentPropertyPath<P> append(P property) {
        Assert.notNull(property, "Property must not be null");
        if (this.isEmpty()) {
            return new DefaultPersistentPropertyPath<P>(Collections.singletonList(property));
        }
        Class<?> leafPropertyType = this.getLeafProperty().getActualType();
        Assert.isTrue(property.getOwner().getType().equals(leafPropertyType), () -> String.format("Cannot append property %s to type %s", property.getName(), leafPropertyType.getName()));
        ArrayList<P> properties = new ArrayList<P>(this.properties);
        properties.add(property);
        return new DefaultPersistentPropertyPath<P>(properties);
    }

    @Override
    public String toDotPath() {
        return this.toPath(DEFAULT_DELIMITER, DEFAULT_CONVERTER);
    }

    @Override
    public String toDotPath(Converter<? super P, String> converter) {
        return this.toPath(DEFAULT_DELIMITER, converter);
    }

    @Override
    public String toPath(String delimiter) {
        return this.toPath(delimiter, DEFAULT_CONVERTER);
    }

    @Override
    public String toPath(String delimiter, Converter<? super P, String> converter) {
        Assert.hasText(delimiter, "Delimiter must not be null or empty");
        Assert.notNull(converter, "Converter must not be null");
        StringBuilder builder = null;
        for (PersistentProperty property : this.properties) {
            String converted = converter.convert(property);
            if (ObjectUtils.isEmpty(converted)) continue;
            if (builder == null) {
                builder = new StringBuilder();
            }
            if (!builder.isEmpty()) {
                builder.append(delimiter);
            }
            builder.append(converted);
        }
        return builder == null ? "" : builder.toString();
    }

    @Override
    public P getLeafProperty() {
        Assert.state(!this.properties.isEmpty(), "Empty PersistentPropertyPath should not exist");
        return (P)((PersistentProperty)this.properties.get(this.properties.size() - 1));
    }

    @Override
    public P getBaseProperty() {
        Assert.state(!this.properties.isEmpty(), "Empty PersistentPropertyPath should not exist");
        return (P)((PersistentProperty)this.properties.get(0));
    }

    @Override
    public boolean isBasePathOf(PersistentPropertyPath<P> path) {
        Assert.notNull(path, "PersistentPropertyPath must not be null");
        Iterator iterator2 = path.iterator();
        for (PersistentProperty property : this) {
            if (!iterator2.hasNext()) {
                return false;
            }
            PersistentProperty reference = (PersistentProperty)iterator2.next();
            if (property.equals(reference)) continue;
            return false;
        }
        return true;
    }

    @Override
    public PersistentPropertyPath<P> getExtensionForBaseOf(PersistentPropertyPath<P> base) {
        if (!base.isBasePathOf(this)) {
            return this;
        }
        return new DefaultPersistentPropertyPath<P>(this.properties.subList(base.getLength(), this.getLength()));
    }

    @Override
    @Nullable
    public PersistentPropertyPath<P> getParentPath() {
        int size = this.properties.size();
        return size == 1 ? null : new DefaultPersistentPropertyPath<P>(this.properties.subList(0, size - 1));
    }

    @Override
    public int getLength() {
        return this.properties.size();
    }

    @Override
    public Iterator<P> iterator() {
        return this.properties.iterator();
    }

    public boolean containsPropertyOfType(@Nullable TypeInformation<?> type) {
        if (type == null) {
            return false;
        }
        for (PersistentProperty property : this.properties) {
            if (!type.equals(property.getTypeInformation().getActualType())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPersistentPropertyPath)) {
            return false;
        }
        DefaultPersistentPropertyPath that = (DefaultPersistentPropertyPath)o;
        return ObjectUtils.nullSafeEquals(this.properties, that.properties);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.properties);
    }

    @Nullable
    public String toString() {
        return this.toDotPath();
    }
}

