/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class PersistentEntities
implements Streamable<PersistentEntity<?, ? extends PersistentProperty<?>>> {
    private final Lazy<Collection<? extends MappingContext<?, ? extends PersistentProperty<?>>>> contexts;

    public PersistentEntities(Iterable<? extends MappingContext<?, ?>> contexts) {
        Assert.notNull(contexts, "MappingContexts must not be null");
        this.contexts = Lazy.of(() -> contexts instanceof Collection ? (List)contexts : StreamSupport.stream(contexts.spliterator(), false).toList());
    }

    public static PersistentEntities of(MappingContext<?, ?> ... contexts) {
        Assert.notNull(contexts, "MappingContexts must not be null");
        return new PersistentEntities(Arrays.asList(contexts));
    }

    public Optional<PersistentEntity<?, ? extends PersistentProperty<?>>> getPersistentEntity(Class<?> type) {
        for (MappingContext<?, PersistentProperty<?>> context : this.getMappingContexts()) {
            if (!context.hasPersistentEntityFor(type)) continue;
            return Optional.of(context.getRequiredPersistentEntity((PersistentProperty<?>)((Object)type)));
        }
        return Optional.empty();
    }

    public PersistentEntity<?, ? extends PersistentProperty<?>> getRequiredPersistentEntity(Class<?> type) {
        Assert.notNull(type, "Domain type must not be null");
        Collection<MappingContext<?, PersistentProperty<?>>> mappingContexts = this.getMappingContexts();
        if (mappingContexts.size() == 1) {
            return mappingContexts.iterator().next().getRequiredPersistentEntity((PersistentProperty<?>)((Object)type));
        }
        return this.getPersistentEntity(type).orElseThrow(() -> new MappingException(String.format("Cannot get or create PersistentEntity for type %s; PersistentEntities knows about %s MappingContext instances and therefore cannot identify a single responsible one; Please configure the initialEntitySet through an entity scan using the base package in your configuration to pre initialize contexts", type.getName(), mappingContexts.size())));
    }

    public <T> Optional<T> mapOnContext(Class<?> type, BiFunction<MappingContext<?, ? extends PersistentProperty<?>>, PersistentEntity<?, ?>, T> combiner) {
        Assert.notNull(type, "Type must not be null");
        Assert.notNull(combiner, "Combining BiFunction must not be null");
        Collection<MappingContext<?, PersistentProperty<?>>> mappingContexts = this.getMappingContexts();
        if (mappingContexts.size() == 1) {
            return mappingContexts.stream().filter(it -> it.getPersistentEntity(type) != null).map(it -> combiner.apply((MappingContext<?, ? extends PersistentProperty<?>>)it, (PersistentEntity<?, ?>)it.getRequiredPersistentEntity(type))).findFirst();
        }
        return mappingContexts.stream().filter(it -> it.hasPersistentEntityFor(type)).map(it -> combiner.apply((MappingContext<?, ? extends PersistentProperty<?>>)it, (PersistentEntity<?, ?>)it.getRequiredPersistentEntity(type))).findFirst();
    }

    public Streamable<TypeInformation<?>> getManagedTypes() {
        HashSet target = new HashSet();
        for (MappingContext<?, PersistentProperty<?>> context : this.getMappingContexts()) {
            target.addAll(context.getManagedTypes());
        }
        return Streamable.of(target);
    }

    @Override
    public Iterator<PersistentEntity<?, ? extends PersistentProperty<?>>> iterator() {
        ArrayList target = new ArrayList();
        for (MappingContext<?, PersistentProperty<?>> context : this.getMappingContexts()) {
            target.addAll(context.getPersistentEntities());
        }
        return target.iterator();
    }

    @Nullable
    public PersistentEntity<?, ?> getEntityUltimatelyReferredToBy(PersistentProperty<?> property) {
        TypeInformation<?> propertyType = property.getTypeInformation().getActualType();
        if (propertyType == null || !property.isAssociation()) {
            return null;
        }
        Class<?> associationTargetType = property.getAssociationTargetType();
        return associationTargetType == null ? this.getEntityIdentifiedBy(propertyType) : this.getPersistentEntity(associationTargetType).orElseGet(() -> this.getEntityIdentifiedBy(propertyType));
    }

    public TypeInformation<?> getTypeUltimatelyReferredToBy(PersistentProperty<?> property) {
        Assert.notNull(property, "PersistentProperty must not be null");
        PersistentEntity<?, ?> entity = this.getEntityUltimatelyReferredToBy(property);
        return entity == null ? property.getTypeInformation().getRequiredActualType() : entity.getTypeInformation();
    }

    @Nullable
    private PersistentEntity<?, ?> getEntityIdentifiedBy(TypeInformation<?> type) {
        Collection<PersistentEntity<?, ?>> entities = this.getPersistentEntities(type);
        if (entities.size() > 1) {
            String message = "Found multiple entities identified by " + String.valueOf(type.getType()) + ": ";
            message = message + entities.stream().map(it -> it.getType().getName()).collect(Collectors.joining(", "));
            message = message + "; Introduce dedicated unique identifier types or explicitly define the target type in @Reference";
            throw new IllegalStateException(message);
        }
        return entities.isEmpty() ? null : entities.iterator().next();
    }

    private Collection<PersistentEntity<?, ?>> getPersistentEntities(TypeInformation<?> type) {
        ArrayList entities = new ArrayList();
        for (MappingContext<?, PersistentProperty<?>> context : this.getMappingContexts()) {
            for (PersistentEntity persistentProperties : context.getPersistentEntities()) {
                Object idProperty = persistentProperties.getIdProperty();
                if (idProperty == null || !type.equals(idProperty.getTypeInformation().getActualType())) continue;
                PersistentEntity owner = idProperty.getOwner();
                entities.add(owner);
            }
        }
        return entities;
    }

    private Collection<? extends MappingContext<?, ? extends PersistentProperty<?>>> getMappingContexts() {
        return this.contexts.get();
    }
}

