/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class KotlinValueUtils {
    KotlinValueUtils() {
    }

    public static ValueBoxing getCopyValueHierarchy(KParameter parameter) {
        return new ValueBoxing(BoxingRules.COPY, parameter);
    }

    public static ValueBoxing getConstructorValueHierarchy(KParameter parameter) {
        return new ValueBoxing(BoxingRules.CONSTRUCTOR, parameter);
    }

    public static ValueBoxing getConstructorValueHierarchy(Class<?> cls) {
        KClass<?> kotlinClass = JvmClassMappingKt.getKotlinClass(cls);
        return new ValueBoxing(BoxingRules.CONSTRUCTOR, KotlinValueUtils.typeOf(kotlinClass), kotlinClass, false);
    }

    private static KType typeOf(KClass<?> kotlinClass) {
        return kotlinClass.getTypeParameters().isEmpty() ? Reflection.typeOf(kotlinClass) : Reflection.typeOf(JvmClassMappingKt.getJavaClass(kotlinClass), KotlinValueUtils.stubKTypeProjections(kotlinClass));
    }

    private static KTypeProjection[] stubKTypeProjections(KClass<?> kotlinClass) {
        Object[] kTypeProjections = new KTypeProjection[kotlinClass.getTypeParameters().size()];
        Arrays.fill(kTypeProjections, KTypeProjection.star);
        return kTypeProjections;
    }

    static class ValueBoxing {
        private final KClass<?> kClass;
        private final KFunction<?> wrapperConstructor;
        private final KProperty<?> valueProperty;
        private final boolean applyBoxing;
        @Nullable
        private final ValueBoxing next;

        private ValueBoxing(BoxingRules rules, KParameter parameter) {
            this(rules, parameter.getType(), ValueBoxing.resolveClass(parameter.getType()), parameter.isOptional());
        }

        private static KClass<?> resolveClass(KType type) {
            if (type instanceof KClass) {
                KClass kc = (KClass)((Object)type);
                return kc;
            }
            if (type instanceof KTypeParameter) {
                KTypeParameter ktp = (KTypeParameter)((Object)type);
                return ValueBoxing.resolveClass(ktp.getUpperBounds().get(0));
            }
            KClassifier classifier = type.getClassifier();
            if (classifier != null) {
                return ValueBoxing.resolveClass(classifier);
            }
            return JvmClassMappingKt.getKotlinClass(Object.class);
        }

        private static KClass<?> resolveClass(KClassifier classifier) {
            if (classifier instanceof KClass) {
                KClass kc = (KClass)classifier;
                return kc;
            }
            if (classifier instanceof KTypeParameter) {
                KTypeParameter ktp = (KTypeParameter)classifier;
                return ValueBoxing.resolveClass(ktp.getUpperBounds().get(0));
            }
            if (classifier instanceof KType) {
                KType ktp = (KType)((Object)classifier);
                return ValueBoxing.resolveClass(ktp);
            }
            throw new UnsupportedOperationException(String.format("Unsupported KClassifier: %s", classifier));
        }

        private ValueBoxing(BoxingRules rules, KType type, KClass<?> kClass, boolean optional) {
            boolean applyBoxing;
            KFunction<?> wrapperConstructor = null;
            ValueBoxing next = null;
            if (kClass.isValue()) {
                KClass<?> nestedClass;
                wrapperConstructor = kClass.getConstructors().iterator().next();
                KParameter nested = wrapperConstructor.getParameters().get(0);
                KType nestedType = nested.getType();
                applyBoxing = rules.shouldApplyBoxing(type, optional, nested);
                KClassifier kClassifier = nestedType.getClassifier();
                if (kClassifier instanceof KTypeParameter) {
                    KTypeParameter ktp = (KTypeParameter)kClassifier;
                    nestedClass = ValueBoxing.getUpperBound(ktp);
                } else {
                    nestedClass = (KClass<?>)nestedType.getClassifier();
                }
                Assert.notNull(nestedClass, () -> String.format("Cannot resolve nested class from type %s", nestedType));
                this.valueProperty = kClass.getMembers().stream().filter(it -> it instanceof KProperty).map(KProperty.class::cast).findFirst().get();
                next = new ValueBoxing(rules, nestedType, nestedClass, nested.isOptional());
            } else {
                applyBoxing = false;
                this.valueProperty = null;
            }
            this.kClass = kClass;
            this.wrapperConstructor = wrapperConstructor;
            this.next = next;
            this.applyBoxing = applyBoxing;
        }

        private static KClass<?> getUpperBound(KTypeParameter typeParameter) {
            for (KType upperBound : typeParameter.getUpperBounds()) {
                KClassifier kClassifier = upperBound.getClassifier();
                if (!(kClassifier instanceof KClass)) continue;
                KClass kc = (KClass)kClassifier;
                return kc;
            }
            throw new IllegalArgumentException("No upper bounds found");
        }

        static KType resolveType(KType type) {
            KClassifier kClassifier = type.getClassifier();
            if (kClassifier instanceof KTypeParameter) {
                KTypeParameter ktp = (KTypeParameter)kClassifier;
                for (KType upperBound : ktp.getUpperBounds()) {
                    KClassifier kClassifier2 = upperBound.getClassifier();
                    if (!(kClassifier2 instanceof KClass)) continue;
                    KClass kc = (KClass)kClassifier2;
                    return upperBound;
                }
            }
            return type;
        }

        public Class<?> getActualType() {
            if (this.isValueClass() && this.hasNext()) {
                return this.getNext().getActualType();
            }
            return JvmClassMappingKt.getJavaClass(this.kClass);
        }

        public Class<?> getParameterType() {
            if (this.hasNext() && this.getNext().appliesBoxing()) {
                return this.next.getParameterType();
            }
            return JvmClassMappingKt.getJavaClass(this.kClass);
        }

        public boolean appliesBoxing() {
            return this.applyBoxing;
        }

        public boolean isValueClass() {
            return this.kClass.isValue();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public ValueBoxing getNext() {
            if (this.next == null) {
                throw new IllegalStateException("No next ValueBoxing available");
            }
            return this.next;
        }

        @Nullable
        public Object wrap(@Nullable Object o) {
            return this.doWrap(o, false, ValueBoxing::wrap);
        }

        @Nullable
        Object applyWrapping(@Nullable Object o) {
            return this.doWrap(o, true, ValueBoxing::applyWrapping);
        }

        @Nullable
        Object doWrap(@Nullable Object o, boolean unwrap2, BiFunction<ValueBoxing, Object, Object> nextWrapStage) {
            if (this.applyBoxing) {
                return o == null || this.kClass.isInstance(o) ? o : this.wrapperConstructor.call(nextWrapStage.apply(this.next, o));
            }
            if (unwrap2 && this.kClass.isValue() && o != null && this.kClass.isInstance(o)) {
                o = this.valueProperty.getGetter().call(o);
            }
            if (this.hasNext()) {
                return nextWrapStage.apply(this.next, o);
            }
            return o;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            ValueBoxing hierarchy = this;
            while (hierarchy != null) {
                if (!sb.isEmpty()) {
                    sb.append(" -> ");
                }
                sb.append(hierarchy.kClass.getSimpleName());
                hierarchy = hierarchy.next;
            }
            return sb.toString();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum BoxingRules {
        CONSTRUCTOR{

            @Override
            public boolean shouldApplyBoxing(KType type, boolean optional, KParameter component) {
                Type javaType = ReflectJvmMapping.getJavaType((KType)component.getType());
                if (type.isMarkedNullable() || optional) {
                    Class c;
                    boolean isPrimitive = javaType instanceof Class && (c = (Class)javaType).isPrimitive();
                    return isPrimitive && type.isMarkedNullable() || component.getType().isMarkedNullable();
                }
                return false;
            }
        }
        ,
        COPY{

            @Override
            public boolean shouldApplyBoxing(KType type, boolean optional, KParameter component) {
                KClass kc;
                KType copyType = 2.expandUnderlyingType(type);
                KClassifier kClassifier = copyType.getClassifier();
                return kClassifier instanceof KClass && (kc = (KClass)kClassifier).isValue() || copyType.isMarkedNullable();
            }

            private static KType expandUnderlyingType(KType kotlinType) {
                Class c;
                boolean isPrimitive;
                KClass kc;
                KClassifier kClassifier = kotlinType.getClassifier();
                if (!(kClassifier instanceof KClass) || !(kc = (KClass)kClassifier).isValue()) {
                    return kotlinType;
                }
                List<KProperty<?>> properties = 2.getProperties(kc);
                if (properties.isEmpty()) {
                    return kotlinType;
                }
                KType underlyingType = properties.get(0).getReturnType();
                KType componentType = ValueBoxing.resolveType(underlyingType);
                KType expandedUnderlyingType = 2.expandUnderlyingType(componentType);
                if (!kotlinType.isMarkedNullable()) {
                    return expandedUnderlyingType;
                }
                if (expandedUnderlyingType.isMarkedNullable()) {
                    return kotlinType;
                }
                Type javaType = ReflectJvmMapping.getJavaType((KType)expandedUnderlyingType);
                boolean bl = isPrimitive = javaType instanceof Class && (c = (Class)javaType).isPrimitive();
                if (isPrimitive) {
                    return kotlinType;
                }
                return expandedUnderlyingType;
            }

            static List<KProperty<?>> getProperties(KClass<?> kClass) {
                if (kClass.isValue()) {
                    for (KCallable<?> member : kClass.getMembers()) {
                        if (!(member instanceof KProperty)) continue;
                        KProperty kp = (KProperty)member;
                        return Collections.singletonList(kp);
                    }
                }
                ArrayList properties = new ArrayList();
                for (KCallable<?> member : kClass.getMembers()) {
                    if (!(member instanceof KProperty)) continue;
                    KProperty kp = (KProperty)member;
                    properties.add(kp);
                }
                return properties;
            }
        };


        public abstract boolean shouldApplyBoxing(KType var1, boolean var2, KParameter var3);
    }
}

