/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.data.mapping.FactoryMethod;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.KotlinInstantiationDelegate;
import org.springframework.data.mapping.model.MappingInstantiationException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.util.KotlinReflectionUtils;
import org.springframework.util.ReflectionUtils;

enum ReflectionEntityInstantiator implements EntityInstantiator
{
    INSTANCE;

    private static final Object[] EMPTY_ARGS;

    @Override
    public <T, E extends PersistentEntity<? extends T, P>, P extends PersistentProperty<P>> T createInstance(E entity, ParameterValueProvider<P> provider) {
        PreferredConstructor constructor;
        PreferredConstructor<?, ?> kotlinJvmConstructor;
        InstanceCreatorMetadata<P> creator = entity.getInstanceCreatorMetadata();
        if (creator == null) {
            return this.instantiateClass(entity);
        }
        if (KotlinDetector.isKotlinReflectPresent() && KotlinReflectionUtils.isSupportedKotlinClass(entity.getType()) && creator instanceof PreferredConstructor && (kotlinJvmConstructor = KotlinInstantiationDelegate.resolveKotlinJvmConstructor(constructor = (PreferredConstructor)creator)) != null) {
            return ReflectionEntityInstantiator.instantiateKotlinClass(entity, provider, constructor, kotlinJvmConstructor);
        }
        int parameterCount = creator.getParameterCount();
        Object[] params = parameterCount == 0 ? EMPTY_ARGS : new Object[parameterCount];
        int i2 = 0;
        for (Parameter<Object, P> parameter : creator.getParameters()) {
            params[i2++] = provider.getParameterValue(parameter);
        }
        if (creator instanceof FactoryMethod) {
            FactoryMethod method = (FactoryMethod)creator;
            try {
                Object t = ReflectionUtils.invokeMethod(method.getFactoryMethod(), null, params);
                if (t == null) {
                    throw new IllegalStateException("Method %s returned null".formatted(method.getFactoryMethod()));
                }
                return (T)t;
            }
            catch (Exception e) {
                throw new MappingInstantiationException(entity, new ArrayList<Object>(Arrays.asList(params)), e);
            }
        }
        try {
            return BeanUtils.instantiateClass(((PreferredConstructor)creator).getConstructor(), params);
        }
        catch (BeanInstantiationException e) {
            throw new MappingInstantiationException(entity, new ArrayList<Object>(Arrays.asList(params)), e);
        }
    }

    private static <T, E extends PersistentEntity<? extends T, P>, P extends PersistentProperty<P>> T instantiateKotlinClass(E entity, ParameterValueProvider<P> provider, PreferredConstructor<?, ?> preferredConstructor, PreferredConstructor<?, ? extends PersistentProperty<?>> kotlinJvmConstructor) {
        Constructor<?> ctor = kotlinJvmConstructor.getConstructor();
        KotlinInstantiationDelegate delegate = new KotlinInstantiationDelegate(preferredConstructor, ctor);
        Object[] params = new Object[delegate.getRequiredParameterCount()];
        delegate.extractInvocationArguments(params, entity.getInstanceCreatorMetadata(), provider);
        try {
            return (T)ctor.newInstance(params);
        }
        catch (InstantiationException ex) {
            throw new BeanInstantiationException(ctor, "Is it an abstract class?", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanInstantiationException(ctor, "Is the preferredConstructor accessible?", (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new BeanInstantiationException(ctor, "Illegal arguments for preferredConstructor", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new BeanInstantiationException(ctor, "Constructor threw exception", ex.getTargetException());
        }
    }

    private <T, E extends PersistentEntity<? extends T, P>, P extends PersistentProperty<P>> T instantiateClass(E entity) {
        try {
            Class<T> clazz = entity.getType();
            if (clazz.isArray()) {
                Class<Object> ctype = clazz;
                int dims = 0;
                while (ctype.isArray()) {
                    ctype = ctype.getComponentType();
                    ++dims;
                }
                return (T)Array.newInstance(clazz, dims);
            }
            return BeanUtils.instantiateClass(entity.getType());
        }
        catch (BeanInstantiationException e) {
            throw new MappingInstantiationException(entity, Collections.emptyList(), e);
        }
    }

    static {
        EMPTY_ARGS = new Object[0];
    }
}

