/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ValueExpressionParameterValueProvider<P extends PersistentProperty<P>>
implements ParameterValueProvider<P> {
    private final ValueExpressionEvaluator evaluator;
    private final ConversionService conversionService;
    private final ParameterValueProvider<P> delegate;

    public ValueExpressionParameterValueProvider(ValueExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<P> delegate) {
        Assert.notNull((Object)evaluator, "ValueExpressionEvaluator must not be null");
        Assert.notNull((Object)conversionService, "ConversionService must not be null");
        Assert.notNull(delegate, "Delegate must not be null");
        this.evaluator = evaluator;
        this.conversionService = conversionService;
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public <T> T getParameterValue(Parameter<T, P> parameter) {
        if (!parameter.hasValueExpression()) {
            return this.delegate.getParameterValue(parameter);
        }
        String rawExpressionString = parameter.getRequiredValueExpression();
        String expressionString = rawExpressionString.contains("#{") || rawExpressionString.contains("${") ? rawExpressionString : "#{" + rawExpressionString + "}";
        Object object = this.evaluator.evaluate(expressionString);
        return object == null ? null : (T)this.potentiallyConvertExpressionValue(object, parameter);
    }

    @Nullable
    @Deprecated(since="3.3")
    protected <T> T potentiallyConvertSpelValue(Object object, Parameter<T, P> parameter) {
        return this.conversionService.convert(object, parameter.getRawType());
    }

    @Nullable
    protected <T> T potentiallyConvertExpressionValue(Object object, Parameter<T, P> parameter) {
        return this.potentiallyConvertSpelValue(object, parameter);
    }
}

