/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.log.LogMessage;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.core.metrics.StartupStep;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.BootstrapMode;
import org.springframework.data.repository.config.DeferredRepositoryInitializationListener;
import org.springframework.data.repository.config.RepositoryBeanDefinitionBuilder;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationAdapter;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.AbstractRepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StopWatch;

public class RepositoryConfigurationDelegate {
    private static final String REPOSITORY_REGISTRATION = "Spring Data %s - Registering repository: %s - Interface: %s - Factory: %s";
    private static final String MULTIPLE_MODULES = "Multiple Spring Data modules found, entering strict repository configuration mode";
    private static final String NON_DEFAULT_AUTOWIRE_CANDIDATE_RESOLVER = "Non-default AutowireCandidateResolver (%s) detected. Skipping the registration of LazyRepositoryInjectionPointResolver. Lazy repository injection will not be working";
    private static final List<Class<?>> DEFAULT_AUTOWIRE_CANDIDATE_RESOLVERS = List.of(ContextAnnotationAutowireCandidateResolver.class, LazyRepositoryInjectionPointResolver.class);
    private static final Log logger = LogFactory.getLog(RepositoryConfigurationDelegate.class);
    private final RepositoryConfigurationSource configurationSource;
    private final ResourceLoader resourceLoader;
    private final Environment environment;
    private final boolean isXml;
    private final boolean inMultiStoreMode;

    public RepositoryConfigurationDelegate(RepositoryConfigurationSource configurationSource, ResourceLoader resourceLoader, Environment environment2) {
        this.isXml = configurationSource instanceof XmlRepositoryConfigurationSource;
        boolean isAnnotation = configurationSource instanceof AnnotationRepositoryConfigurationSource;
        Assert.isTrue(this.isXml || isAnnotation, "Configuration source must either be an Xml- or an AnnotationBasedConfigurationSource");
        Assert.notNull((Object)resourceLoader, "ResourceLoader must not be null");
        this.configurationSource = configurationSource;
        this.resourceLoader = resourceLoader;
        this.environment = RepositoryConfigurationDelegate.defaultEnvironment(environment2, resourceLoader);
        this.inMultiStoreMode = this.multipleStoresDetected();
    }

    private static Environment defaultEnvironment(@Nullable Environment environment2, @Nullable ResourceLoader resourceLoader) {
        Environment environment3;
        if (environment2 != null) {
            return environment2;
        }
        if (resourceLoader instanceof EnvironmentCapable) {
            EnvironmentCapable capable = (EnvironmentCapable)((Object)resourceLoader);
            environment3 = capable.getEnvironment();
        } else {
            environment3 = new StandardEnvironment();
        }
        return environment3;
    }

    public List<BeanComponentDefinition> registerRepositoriesIn(BeanDefinitionRegistry registry, RepositoryConfigurationExtension extension) {
        if (logger.isInfoEnabled()) {
            logger.info(LogMessage.format("Bootstrapping Spring Data %s repositories in %s mode.", (Object)extension.getModuleName(), (Object)this.configurationSource.getBootstrapMode().name()));
        }
        extension.registerBeansForRoot(registry, this.configurationSource);
        RepositoryBeanDefinitionBuilder builder = new RepositoryBeanDefinitionBuilder(registry, extension, this.configurationSource, this.resourceLoader, this.environment);
        if (logger.isDebugEnabled()) {
            logger.debug(LogMessage.format("Scanning for %s repositories in packages %s.", (Object)extension.getModuleName(), (Object)this.configurationSource.getBasePackages().stream().collect(Collectors.joining(", "))));
        }
        StopWatch watch = new StopWatch();
        ApplicationStartup startup = RepositoryConfigurationDelegate.getStartup(registry);
        StartupStep repoScan = startup.start("spring.data.repository.scanning");
        repoScan.tag("dataModule", extension.getModuleName());
        repoScan.tag("basePackages", () -> this.configurationSource.getBasePackages().stream().collect(Collectors.joining(", ")));
        watch.start();
        Collection<RepositoryConfiguration<RepositoryConfigurationSource>> configurations = extension.getRepositoryConfigurations(this.configurationSource, this.resourceLoader, this.inMultiStoreMode);
        ArrayList<BeanComponentDefinition> definitions = new ArrayList<BeanComponentDefinition>();
        HashMap configurationsByRepositoryName = new HashMap(configurations.size());
        HashMap metadataByRepositoryBeanName = new HashMap(configurations.size());
        for (RepositoryConfiguration<RepositoryConfigurationSource> configuration : configurations) {
            configurationsByRepositoryName.put(configuration.getRepositoryInterface(), configuration);
            BeanDefinitionBuilder definitionBuilder = builder.build(configuration);
            extension.postProcess(definitionBuilder, this.configurationSource);
            if (this.isXml) {
                extension.postProcess(definitionBuilder, (XmlRepositoryConfigurationSource)this.configurationSource);
            } else {
                extension.postProcess(definitionBuilder, (AnnotationRepositoryConfigurationSource)this.configurationSource);
            }
            RootBeanDefinition beanDefinition = (RootBeanDefinition)definitionBuilder.getBeanDefinition();
            beanDefinition.setTargetType(this.getRepositoryFactoryBeanType(configuration));
            beanDefinition.setResourceDescription(configuration.getResourceDescription());
            String beanName = this.configurationSource.generateBeanName(beanDefinition);
            if (logger.isTraceEnabled()) {
                logger.trace(LogMessage.format(REPOSITORY_REGISTRATION, (Object)extension.getModuleName(), (Object)beanName, (Object)configuration.getRepositoryInterface(), (Object)configuration.getRepositoryFactoryBeanClassName()));
            }
            metadataByRepositoryBeanName.put(beanName, builder.buildMetadata(configuration));
            registry.registerBeanDefinition(beanName, beanDefinition);
            definitions.add(new BeanComponentDefinition(beanDefinition, beanName));
        }
        RepositoryConfigurationDelegate.potentiallyLazifyRepositories(configurationsByRepositoryName, registry, this.configurationSource.getBootstrapMode());
        watch.stop();
        repoScan.tag("repository.count", Integer.toString(configurations.size()));
        repoScan.end();
        if (logger.isInfoEnabled()) {
            logger.info(LogMessage.format("Finished Spring Data repository scanning in %s ms. Found %s %s repository interface%s.", (Object)watch.lastTaskInfo().getTimeMillis(), (Object)configurations.size(), (Object)extension.getModuleName(), (Object)(configurations.size() == 1 ? "" : "s")));
        }
        this.registerAotComponents(registry, extension, metadataByRepositoryBeanName);
        return definitions;
    }

    private void registerAotComponents(BeanDefinitionRegistry registry, RepositoryConfigurationExtension extension, Map<String, RepositoryConfigurationAdapter<?>> metadataByRepositoryBeanName) {
        BeanDefinitionBuilder repositoryAotProcessor = BeanDefinitionBuilder.rootBeanDefinition(extension.getRepositoryAotProcessor()).setRole(2);
        repositoryAotProcessor.addPropertyValue("configMap", metadataByRepositoryBeanName);
        String repositoryAotProcessorBeanName = String.format("data-%s.repository-aot-processor", extension.getModuleIdentifier());
        registry.registerBeanDefinition(BeanDefinitionReaderUtils.uniqueBeanName(repositoryAotProcessorBeanName, registry), repositoryAotProcessor.getBeanDefinition());
    }

    private static void potentiallyLazifyRepositories(Map<String, RepositoryConfiguration<?>> configurations, BeanDefinitionRegistry registry, BootstrapMode mode) {
        LazyRepositoryInjectionPointResolver lazyRepositoryInjectionPointResolver;
        DefaultListableBeanFactory beanFactory;
        block8: {
            block7: {
                if (!(registry instanceof DefaultListableBeanFactory)) break block7;
                beanFactory = (DefaultListableBeanFactory)registry;
                if (!BootstrapMode.DEFAULT.equals((Object)mode)) break block8;
            }
            return;
        }
        AutowireCandidateResolver resolver = beanFactory.getAutowireCandidateResolver();
        if (!DEFAULT_AUTOWIRE_CANDIDATE_RESOLVERS.contains(resolver.getClass())) {
            logger.warn(LogMessage.format(NON_DEFAULT_AUTOWIRE_CANDIDATE_RESOLVER, (Object)resolver.getClass().getName()));
            return;
        }
        if (resolver instanceof LazyRepositoryInjectionPointResolver) {
            LazyRepositoryInjectionPointResolver lazy = (LazyRepositoryInjectionPointResolver)resolver;
            lazyRepositoryInjectionPointResolver = lazy.withAdditionalConfigurations(configurations);
        } else {
            lazyRepositoryInjectionPointResolver = new LazyRepositoryInjectionPointResolver(configurations);
        }
        LazyRepositoryInjectionPointResolver newResolver = lazyRepositoryInjectionPointResolver;
        beanFactory.setAutowireCandidateResolver(newResolver);
        if (mode.equals((Object)BootstrapMode.DEFERRED) && !beanFactory.containsBean(DeferredRepositoryInitializationListener.class.getName())) {
            logger.debug("Registering deferred repository initialization listener.");
            beanFactory.registerSingleton(DeferredRepositoryInitializationListener.class.getName(), new DeferredRepositoryInitializationListener(beanFactory));
        }
    }

    private boolean multipleStoresDetected() {
        boolean multipleModulesFound;
        boolean bl = multipleModulesFound = SpringFactoriesLoader.loadFactoryNames(RepositoryFactorySupport.class, this.resourceLoader.getClassLoader()).size() > 1;
        if (multipleModulesFound) {
            logger.info(MULTIPLE_MODULES);
        }
        return multipleModulesFound;
    }

    private static ApplicationStartup getStartup(BeanDefinitionRegistry registry) {
        if (registry instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)((Object)registry)).getApplicationStartup();
        }
        if (registry instanceof GenericApplicationContext) {
            return ((GenericApplicationContext)registry).getDefaultListableBeanFactory().getApplicationStartup();
        }
        return ApplicationStartup.DEFAULT;
    }

    @Nullable
    private ResolvableType getRepositoryFactoryBeanType(RepositoryConfiguration<?> configuration) {
        String interfaceName = configuration.getRepositoryInterface();
        ClassLoader classLoader = this.resourceLoader.getClassLoader() == null ? ClassUtils.getDefaultClassLoader() : this.resourceLoader.getClassLoader();
        Class<?> repositoryInterface = org.springframework.data.util.ClassUtils.loadIfPresent(interfaceName, classLoader = classLoader != null ? classLoader : this.getClass().getClassLoader());
        if (repositoryInterface == null) {
            return null;
        }
        Class<?> factoryBean = org.springframework.data.util.ClassUtils.loadIfPresent(configuration.getRepositoryFactoryBeanClassName(), classLoader);
        if (factoryBean == null) {
            return null;
        }
        RepositoryMetadata metadata = AbstractRepositoryMetadata.getMetadata(repositoryInterface);
        List<Class<?>> types = List.of(repositoryInterface, metadata.getDomainType(), metadata.getIdType());
        ResolvableType[] declaredGenerics = ResolvableType.forClass(factoryBean).getGenerics();
        ResolvableType[] parentGenerics = ResolvableType.forClass(RepositoryFactoryBeanSupport.class, factoryBean).getGenerics();
        ArrayList<ResolvableType> resolvedGenerics = new ArrayList<ResolvableType>(factoryBean.getTypeParameters().length);
        for (int i2 = 0; i2 < parentGenerics.length; ++i2) {
            ResolvableType parameter = parentGenerics[i2];
            if (!(parameter.getType() instanceof TypeVariable)) continue;
            resolvedGenerics.add(i2 < types.size() ? ResolvableType.forClass(types.get(i2)) : parameter);
        }
        if (resolvedGenerics.size() < declaredGenerics.length) {
            resolvedGenerics.addAll(Arrays.asList(declaredGenerics).subList(parentGenerics.length, declaredGenerics.length));
        }
        return ResolvableType.forClassWithGenerics(factoryBean, (ResolvableType[])resolvedGenerics.subList(0, declaredGenerics.length).toArray(ResolvableType[]::new));
    }

    static class LazyRepositoryInjectionPointResolver
    extends ContextAnnotationAutowireCandidateResolver {
        private static final Log logger = LogFactory.getLog(LazyRepositoryInjectionPointResolver.class);
        private final Map<String, RepositoryConfiguration<?>> configurations;

        public LazyRepositoryInjectionPointResolver(Map<String, RepositoryConfiguration<?>> configurations) {
            this.configurations = configurations;
        }

        LazyRepositoryInjectionPointResolver withAdditionalConfigurations(Map<String, RepositoryConfiguration<?>> configurations) {
            HashMap map = new HashMap(this.configurations);
            map.putAll(configurations);
            return new LazyRepositoryInjectionPointResolver(map);
        }

        @Override
        protected boolean isLazy(DependencyDescriptor descriptor) {
            Class<?> type = descriptor.getDependencyType();
            RepositoryConfiguration<?> configuration = this.configurations.get(type.getName());
            if (configuration == null) {
                return super.isLazy(descriptor);
            }
            boolean lazyInit = configuration.isLazyInit();
            if (lazyInit) {
                logger.debug(LogMessage.format("Creating lazy injection proxy for %s\u2026", (Object)configuration.getRepositoryInterface()));
            }
            return lazyInit;
        }
    }
}

