/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.beans.Introspector;
import java.util.Optional;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.data.config.ConfigurationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public final class RepositoryFragmentConfiguration {
    private final Optional<String> interfaceName;
    private final String className;
    private final Optional<AbstractBeanDefinition> beanDefinition;
    private final String beanName;

    public RepositoryFragmentConfiguration(@Nullable String interfaceName, String className) {
        this(interfaceName, className, Optional.empty(), RepositoryFragmentConfiguration.generateBeanName(className));
    }

    public RepositoryFragmentConfiguration(@Nullable String interfaceName, AbstractBeanDefinition beanDefinition) {
        Assert.notNull((Object)beanDefinition, "Bean definition must not be null");
        this.interfaceName = Optional.ofNullable(interfaceName);
        this.className = ConfigurationUtils.getRequiredBeanClassName(beanDefinition);
        this.beanDefinition = Optional.of(beanDefinition);
        this.beanName = this.generateBeanName();
    }

    RepositoryFragmentConfiguration(@Nullable String interfaceName, AbstractBeanDefinition beanDefinition, String beanName) {
        this(interfaceName, ConfigurationUtils.getRequiredBeanClassName(beanDefinition), Optional.of(beanDefinition), beanName);
    }

    private RepositoryFragmentConfiguration(@Nullable String interfaceName, String className, Optional<AbstractBeanDefinition> beanDefinition, String beanName) {
        Assert.notNull(beanDefinition, "Bean definition must not be null");
        Assert.notNull((Object)beanName, "Bean name must not be null");
        this.interfaceName = Optional.ofNullable(interfaceName);
        this.className = className;
        this.beanDefinition = beanDefinition;
        this.beanName = beanName;
    }

    private String generateBeanName() {
        return RepositoryFragmentConfiguration.generateBeanName(this.getClassName());
    }

    private static String generateBeanName(String className) {
        return Introspector.decapitalize(ClassUtils.getShortName(className));
    }

    public String getImplementationBeanName() {
        return this.beanName;
    }

    public String getFragmentBeanName() {
        return this.getImplementationBeanName() + "Fragment";
    }

    @Nullable
    public String getInterfaceName() {
        return this.interfaceName.orElse(null);
    }

    public String getClassName() {
        return this.className;
    }

    public Optional<AbstractBeanDefinition> getBeanDefinition() {
        return this.beanDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RepositoryFragmentConfiguration)) {
            return false;
        }
        RepositoryFragmentConfiguration that = (RepositoryFragmentConfiguration)o;
        if (!ObjectUtils.nullSafeEquals(this.interfaceName, that.interfaceName)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.className, that.className)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.beanDefinition, that.beanDefinition);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.interfaceName);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.className);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.beanDefinition);
        return result;
    }

    public String toString() {
        return "RepositoryFragmentConfiguration(interfaceName=" + this.getInterfaceName() + ", className=" + this.getClassName() + ", beanDefinition=" + String.valueOf(this.getBeanDefinition()) + ")";
    }
}

