/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.aot.AotContext;
import org.springframework.data.projection.EntityProjectionIntrospector;
import org.springframework.data.projection.TargetAware;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.config.DefaultAotRepositoryContext;
import org.springframework.data.repository.config.RepositoryBeanDefinitionReader;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryRegistrationAotProcessor;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.util.QTypeContributor;
import org.springframework.data.util.TypeContributor;
import org.springframework.data.util.TypeUtils;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class RepositoryRegistrationAotContribution
implements BeanRegistrationAotContribution {
    private static final String KOTLIN_COROUTINE_REPOSITORY_TYPE_NAME = "org.springframework.data.repository.kotlin.CoroutineCrudRepository";
    private AotRepositoryContext repositoryContext;
    private BiConsumer<AotRepositoryContext, GenerationContext> moduleContribution;
    private final RepositoryRegistrationAotProcessor repositoryRegistrationAotProcessor;

    public static RepositoryRegistrationAotContribution fromProcessor(RepositoryRegistrationAotProcessor repositoryRegistrationAotProcessor) {
        return new RepositoryRegistrationAotContribution(repositoryRegistrationAotProcessor);
    }

    protected RepositoryRegistrationAotContribution(RepositoryRegistrationAotProcessor repositoryRegistrationAotProcessor) {
        Assert.notNull((Object)repositoryRegistrationAotProcessor, "RepositoryRegistrationAotProcessor must not be null");
        this.repositoryRegistrationAotProcessor = repositoryRegistrationAotProcessor;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        return this.getRepositoryRegistrationAotProcessor().getBeanFactory();
    }

    protected Optional<BiConsumer<AotRepositoryContext, GenerationContext>> getModuleContribution() {
        return Optional.ofNullable(this.moduleContribution);
    }

    protected AotRepositoryContext getRepositoryContext() {
        Assert.state(this.repositoryContext != null, "The AOT RepositoryContext was not properly initialized; did you call the forBean(:RegisteredBean) method");
        return this.repositoryContext;
    }

    protected RepositoryRegistrationAotProcessor getRepositoryRegistrationAotProcessor() {
        return this.repositoryRegistrationAotProcessor;
    }

    public RepositoryInformation getRepositoryInformation() {
        return this.getRepositoryContext().getRepositoryInformation();
    }

    private void logTrace(String message, Object ... arguments) {
        this.getRepositoryRegistrationAotProcessor().logTrace(message, arguments);
    }

    public RepositoryRegistrationAotContribution forBean(RegisteredBean repositoryBean) {
        Assert.notNull((Object)repositoryBean, "The RegisteredBean for the repository must not be null");
        RepositoryConfiguration<?> repositoryMetadata = this.getRepositoryRegistrationAotProcessor().getRepositoryMetadata(repositoryBean);
        this.repositoryContext = this.buildAotRepositoryContext(repositoryBean, repositoryMetadata);
        return this;
    }

    protected DefaultAotRepositoryContext buildAotRepositoryContext(RegisteredBean bean2, RepositoryConfiguration<?> repositoryMetadata) {
        RepositoryInformation repositoryInformation = this.resolveRepositoryInformation(repositoryMetadata);
        DefaultAotRepositoryContext repositoryContext = new DefaultAotRepositoryContext(AotContext.from(this.getBeanFactory()));
        repositoryContext.setBeanName(bean2.getBeanName());
        repositoryContext.setBasePackages(repositoryMetadata.getBasePackages().toSet());
        repositoryContext.setIdentifyingAnnotations(this.resolveIdentifyingAnnotations());
        repositoryContext.setRepositoryInformation(repositoryInformation);
        return repositoryContext;
    }

    private Set<Class<? extends Annotation>> resolveIdentifyingAnnotations() {
        Set<Class<? extends Annotation>> identifyingAnnotations = Collections.emptySet();
        try {
            Map<String, RepositoryConfigurationExtensionSupport> map = this.getBeanFactory().getBeansOfType(RepositoryConfigurationExtensionSupport.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return identifyingAnnotations;
    }

    private RepositoryInformation resolveRepositoryInformation(RepositoryConfiguration<?> repositoryMetadata) {
        return RepositoryBeanDefinitionReader.readRepositoryInformation(repositoryMetadata, this.getBeanFactory());
    }

    public RepositoryRegistrationAotContribution withModuleContribution(@Nullable BiConsumer<AotRepositoryContext, GenerationContext> moduleContribution) {
        this.moduleContribution = moduleContribution;
        return this;
    }

    @Override
    public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
        this.contributeRepositoryInfo(this.repositoryContext, generationContext);
        this.getModuleContribution().ifPresent(it -> it.accept(this.getRepositoryContext(), generationContext));
    }

    private void contributeRepositoryInfo(AotRepositoryContext repositoryContext, GenerationContext contribution) {
        RepositoryInformation repositoryInformation = this.getRepositoryInformation();
        this.logTrace("Contributing repository information for [%s]", repositoryInformation.getRepositoryInterface());
        contribution.getRuntimeHints().reflection().registerType(repositoryInformation.getRepositoryInterface(), hint -> hint.withMembers(MemberCategory.INVOKE_PUBLIC_METHODS)).registerType(repositoryInformation.getRepositoryBaseClass(), hint -> hint.withMembers(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS));
        TypeContributor.contribute(repositoryInformation.getDomainType(), contribution);
        QTypeContributor.contributeEntityPath(repositoryInformation.getDomainType(), contribution, repositoryContext.getClassLoader());
        for (RepositoryFragment<?> fragment : this.getRepositoryInformation().getFragments()) {
            Class<?> repositoryFragmentType = fragment.getSignatureContributor();
            contribution.getRuntimeHints().reflection().registerType(repositoryFragmentType, hint -> {
                hint.withMembers(MemberCategory.INVOKE_PUBLIC_METHODS);
                if (!repositoryFragmentType.isInterface()) {
                    hint.withMembers(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS);
                }
            });
        }
        contribution.getRuntimeHints().proxies().registerJdkProxy(repositoryInformation.getRepositoryInterface(), SpringProxy.class, Advised.class, DecoratingProxy.class);
        List<TypeReference> transactionalRepositoryProxyTypeReferences = this.transactionalRepositoryProxyTypeReferences(repositoryInformation);
        contribution.getRuntimeHints().proxies().registerJdkProxy(transactionalRepositoryProxyTypeReferences.toArray(new TypeReference[0]));
        if (this.isComponentAnnotatedRepository(repositoryInformation)) {
            transactionalRepositoryProxyTypeReferences.add(TypeReference.of(Serializable.class));
            contribution.getRuntimeHints().proxies().registerJdkProxy(transactionalRepositoryProxyTypeReferences.toArray(new TypeReference[0]));
        }
        if (repositoryInformation.isReactiveRepository()) {
            // empty if block
        }
        if (this.isKotlinCoroutineRepository(repositoryContext, repositoryInformation)) {
            contribution.getRuntimeHints().reflection().registerTypes(this.kotlinRepositoryReflectionTypeReferences(), hint -> {});
        }
        repositoryInformation.getQueryMethods().map(repositoryInformation::getReturnedDomainClass).filter(Class::isInterface).forEach(type -> {
            if (EntityProjectionIntrospector.ProjectionPredicate.typeHierarchy().test((Class<?>)type, repositoryInformation.getDomainType())) {
                this.contributeProjection((Class<?>)type, contribution);
            }
        });
    }

    private boolean isComponentAnnotatedRepository(RepositoryInformation repositoryInformation) {
        return AnnotationUtils.findAnnotation(repositoryInformation.getRepositoryInterface(), Component.class) != null;
    }

    private boolean isKotlinCoroutineRepository(AotRepositoryContext repositoryContext, RepositoryInformation repositoryInformation) {
        return repositoryContext.introspectType(KOTLIN_COROUTINE_REPOSITORY_TYPE_NAME).resolveType().filter(it -> ClassUtils.isAssignable(it, repositoryInformation.getRepositoryInterface())).isPresent();
    }

    private List<TypeReference> kotlinRepositoryReflectionTypeReferences() {
        return new ArrayList<TypeReference>(Arrays.asList(TypeReference.of(KOTLIN_COROUTINE_REPOSITORY_TYPE_NAME), TypeReference.of(Repository.class), TypeReference.of(Iterable.class), TypeReference.of("kotlinx.coroutines.flow.Flow"), TypeReference.of("kotlin.collections.Iterable"), TypeReference.of("kotlin.Unit"), TypeReference.of("kotlin.Long"), TypeReference.of("kotlin.Boolean")));
    }

    private List<TypeReference> transactionalRepositoryProxyTypeReferences(RepositoryInformation repositoryInformation) {
        return new ArrayList<TypeReference>(Arrays.asList(TypeReference.of(repositoryInformation.getRepositoryInterface()), TypeReference.of(Repository.class), TypeReference.of("org.springframework.transaction.interceptor.TransactionalProxy"), TypeReference.of("org.springframework.aop.framework.Advised"), TypeReference.of(DecoratingProxy.class)));
    }

    private void contributeProjection(Class<?> type, GenerationContext generationContext) {
        generationContext.getRuntimeHints().proxies().registerJdkProxy(type, TargetAware.class, SpringProxy.class, DecoratingProxy.class);
    }

    static boolean isJavaOrPrimitiveType(Class<?> type) {
        return TypeUtils.type(type).isPartOf("java") || ClassUtils.isPrimitiveOrWrapper(type) || ClassUtils.isPrimitiveArray(type);
    }

    public Predicate<Class<?>> typeFilter() {
        return it -> true;
    }
}

