/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.expression.ParseException;
import org.springframework.util.ConcurrentLruCache;

public class CachingValueExpressionDelegate
extends ValueExpressionDelegate {
    private final ConcurrentLruCache<String, ValueExpression> expressionCache;

    public CachingValueExpressionDelegate(ValueExpressionDelegate delegate) {
        super(delegate);
        this.expressionCache = new ConcurrentLruCache<String, ValueExpression>(256, delegate.getValueExpressionParser()::parse);
    }

    public CachingValueExpressionDelegate(QueryMethodValueEvaluationContextAccessor providerFactory, ValueExpressionParser valueExpressionParser) {
        super(providerFactory, valueExpressionParser);
        this.expressionCache = new ConcurrentLruCache<String, ValueExpression>(256, valueExpressionParser::parse);
    }

    @Override
    public ValueExpressionParser getValueExpressionParser() {
        return this;
    }

    @Override
    public ValueExpression parse(String expressionString) throws ParseException {
        return this.expressionCache.get(expressionString);
    }
}

