/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.expression.ReactiveValueEvaluationContextProvider;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.data.spel.ExtensionAwareEvaluationContextProvider;
import org.springframework.data.spel.ReactiveEvaluationContextProvider;
import org.springframework.data.spel.ReactiveExtensionAwareEvaluationContextProvider;
import org.springframework.data.spel.spi.ExtensionIdAware;
import org.springframework.data.util.ReactiveWrappers;
import org.springframework.expression.EvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class QueryMethodValueEvaluationContextAccessor {
    public static final EvaluationContextProvider DEFAULT_CONTEXT_PROVIDER = QueryMethodValueEvaluationContextAccessor.createEvaluationContextProvider(Collections.emptyList());
    static final StandardEnvironment ENVIRONMENT = new StandardEnvironment();
    @Nullable
    private final Environment environment;
    private final EvaluationContextProvider evaluationContextProvider;

    public QueryMethodValueEvaluationContextAccessor(ApplicationContext context) {
        Assert.notNull((Object)context, "ApplicationContext must not be null");
        this.environment = context.getEnvironment();
        this.evaluationContextProvider = QueryMethodValueEvaluationContextAccessor.createEvaluationContextProvider(context);
    }

    public QueryMethodValueEvaluationContextAccessor(@Nullable Environment environment2, ListableBeanFactory beanFactory) {
        this(environment2, QueryMethodValueEvaluationContextAccessor.createEvaluationContextProvider(beanFactory));
    }

    public QueryMethodValueEvaluationContextAccessor(@Nullable Environment environment2, EvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)evaluationContextProvider, "EvaluationContextProvider must not be null");
        this.environment = environment2;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    public QueryMethodValueEvaluationContextAccessor(@Nullable Environment environment2, Collection<? extends ExtensionIdAware> extensions) {
        Assert.notNull(extensions, "EvaluationContextExtensions must not be null");
        this.environment = environment2;
        this.evaluationContextProvider = QueryMethodValueEvaluationContextAccessor.createEvaluationContextProvider(extensions);
    }

    private static EvaluationContextProvider createEvaluationContextProvider(ListableBeanFactory factory2) {
        return ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR) ? new ReactiveExtensionAwareEvaluationContextProvider(factory2) : new ExtensionAwareEvaluationContextProvider(factory2);
    }

    private static EvaluationContextProvider createEvaluationContextProvider(Collection<? extends ExtensionIdAware> extensions) {
        return ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR) ? new ReactiveExtensionAwareEvaluationContextProvider(extensions) : new ExtensionAwareEvaluationContextProvider(extensions);
    }

    public static QueryMethodValueEvaluationContextAccessor create() {
        return new QueryMethodValueEvaluationContextAccessor((Environment)ENVIRONMENT, DEFAULT_CONTEXT_PROVIDER);
    }

    EvaluationContextProvider getEvaluationContextProvider() {
        return this.evaluationContextProvider;
    }

    public ValueEvaluationContextProvider create(Parameters<?, ?> parameters) {
        EvaluationContextProvider evaluationContextProvider;
        Assert.notNull(parameters, "Parameters must not be null");
        if (ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR) && (evaluationContextProvider = this.evaluationContextProvider) instanceof ReactiveEvaluationContextProvider) {
            ReactiveEvaluationContextProvider reactive = (ReactiveEvaluationContextProvider)evaluationContextProvider;
            return new DefaultReactiveQueryMethodValueEvaluationContextProvider(this.environment, parameters, reactive);
        }
        return new DefaultQueryMethodValueEvaluationContextProvider(this.environment, parameters, this.evaluationContextProvider);
    }

    static Map<String, Object> collectVariables(Parameters<?, ?> parameters, Object[] arguments) {
        if (parameters.getNumberOfParameters() != arguments.length) {
            throw new IllegalArgumentException("Number of method parameters (%d) must match the number of method invocation arguments (%d)".formatted(parameters.getNumberOfParameters(), arguments.length));
        }
        HashMap<String, Object> variables = new HashMap<String, Object>(parameters.getNumberOfParameters(), 1.0f);
        for (Parameter parameter : parameters) {
            if (parameter.isSpecialParameter()) {
                variables.put(StringUtils.uncapitalize(parameter.getType().getSimpleName()), arguments[parameter.getIndex()]);
            }
            if (!parameter.isNamedParameter()) continue;
            variables.put(parameter.getRequiredName(), arguments[parameter.getIndex()]);
        }
        return variables;
    }

    static class DefaultReactiveQueryMethodValueEvaluationContextProvider
    extends DefaultQueryMethodValueEvaluationContextProvider
    implements ReactiveValueEvaluationContextProvider {
        private final ReactiveEvaluationContextProvider delegate;

        DefaultReactiveQueryMethodValueEvaluationContextProvider(@Nullable Environment environment2, Parameters<?, ?> parameters, ReactiveEvaluationContextProvider delegate) {
            super(environment2, parameters, delegate);
            this.delegate = delegate;
        }

        @Override
        public Mono<ValueEvaluationContext> getEvaluationContextLater(@Nullable Object rootObject) {
            return this.delegate.getEvaluationContextLater(rootObject).map(it -> this.doGetEvaluationContext((EvaluationContext)it, rootObject));
        }

        @Override
        public Mono<ValueEvaluationContext> getEvaluationContextLater(@Nullable Object rootObject, ExpressionDependencies dependencies) {
            return this.delegate.getEvaluationContextLater(rootObject, dependencies).map(it -> this.doGetEvaluationContext((EvaluationContext)it, rootObject));
        }
    }

    static class DefaultQueryMethodValueEvaluationContextProvider
    implements ValueEvaluationContextProvider {
        @Nullable
        final Environment environment;
        final Parameters<?, ?> parameters;
        final EvaluationContextProvider delegate;

        DefaultQueryMethodValueEvaluationContextProvider(@Nullable Environment environment2, Parameters<?, ?> parameters, EvaluationContextProvider delegate) {
            this.environment = environment2;
            this.parameters = parameters;
            this.delegate = delegate;
        }

        @Override
        public ValueEvaluationContext getEvaluationContext(@Nullable Object rootObject) {
            return this.doGetEvaluationContext(this.delegate.getEvaluationContext(rootObject), rootObject);
        }

        @Override
        public ValueEvaluationContext getEvaluationContext(@Nullable Object rootObject, ExpressionDependencies dependencies) {
            return this.doGetEvaluationContext(this.delegate.getEvaluationContext(rootObject, dependencies), rootObject);
        }

        ValueEvaluationContext doGetEvaluationContext(EvaluationContext evaluationContext, @Nullable Object rootObject) {
            if (rootObject instanceof Object[]) {
                Object[] parameterValues = (Object[])rootObject;
                QueryMethodValueEvaluationContextAccessor.collectVariables(this.parameters, parameterValues).forEach(evaluationContext::setVariable);
            }
            return ValueEvaluationContext.of(this.environment, evaluationContext);
        }
    }
}

