/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryFactoryInformation;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.ProxyUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentLruCache;

public class Repositories
implements Iterable<Class<?>> {
    static final Repositories NONE = new Repositories();
    private static final RepositoryFactoryInformation<Object, Object> EMPTY_REPOSITORY_FACTORY_INFO = EmptyRepositoryFactoryInformation.INSTANCE;
    private static final String DOMAIN_TYPE_MUST_NOT_BE_NULL = "Domain type must not be null";
    private final Optional<BeanFactory> beanFactory;
    private final Map<Class<?>, String> repositoryBeanNames;
    private final Map<Class<?>, RepositoryFactoryInformation<Object, Object>> repositoryFactoryInfos;
    private final ConcurrentLruCache<Class<?>, Class<?>> domainTypeMapping = new ConcurrentLruCache<Class, Class>(64, this::getRepositoryDomainTypeFor);

    private Repositories() {
        this.beanFactory = Optional.empty();
        this.repositoryBeanNames = Collections.emptyMap();
        this.repositoryFactoryInfos = Collections.emptyMap();
    }

    public Repositories(ListableBeanFactory factory2) {
        Assert.notNull((Object)factory2, "ListableBeanFactory must not be null");
        this.beanFactory = Optional.of(factory2);
        this.repositoryFactoryInfos = new HashMap();
        this.repositoryBeanNames = new HashMap();
        this.populateRepositoryFactoryInformation(factory2);
    }

    private void populateRepositoryFactoryInformation(ListableBeanFactory factory2) {
        for (String name : BeanFactoryUtils.beanNamesForTypeIncludingAncestors(factory2, RepositoryFactoryInformation.class, false, false)) {
            this.cacheRepositoryFactory(factory2, name);
        }
    }

    private void cacheRepositoryFactory(ListableBeanFactory factory2, String name) {
        RepositoryFactoryInformation repositoryFactoryInformation = factory2.getBean(name, RepositoryFactoryInformation.class);
        RepositoryInformation information = repositoryFactoryInformation.getRepositoryInformation();
        Class<?> domainType = ClassUtils.getUserClass(information.getDomainType());
        Set<Class<?>> alternativeDomainTypes = information.getAlternativeDomainTypes();
        HashSet typesToRegister = new HashSet(alternativeDomainTypes.size() + 1);
        typesToRegister.add(domainType);
        typesToRegister.addAll(alternativeDomainTypes);
        Optional<ConfigurableListableBeanFactory> beanFactory = Optional.of(factory2).map(it -> {
            if (it instanceof ConfigurableListableBeanFactory) {
                return (ConfigurableListableBeanFactory)it;
            }
            if (it instanceof ConfigurableApplicationContext) {
                return ((ConfigurableApplicationContext)it).getBeanFactory();
            }
            return null;
        });
        for (Class clazz : typesToRegister) {
            this.cacheFirstOrPrimary(beanFactory, clazz, repositoryFactoryInformation, BeanFactoryUtils.transformedBeanName(name));
        }
    }

    public boolean hasRepositoryFor(Class<?> domainClass) {
        Assert.notNull(domainClass, DOMAIN_TYPE_MUST_NOT_BE_NULL);
        Class<?> userClass = this.domainTypeMapping.get(ProxyUtils.getUserClass(domainClass));
        return this.repositoryFactoryInfos.containsKey(userClass);
    }

    public Optional<Object> getRepositoryFor(Class<?> domainClass) {
        Assert.notNull(domainClass, DOMAIN_TYPE_MUST_NOT_BE_NULL);
        Class<?> userClass = this.domainTypeMapping.get(ProxyUtils.getUserClass(domainClass));
        Optional<String> repositoryBeanName = Optional.ofNullable(this.repositoryBeanNames.get(userClass));
        return this.beanFactory.flatMap(it -> repositoryBeanName.map(it::getBean));
    }

    private RepositoryFactoryInformation<Object, Object> getRepositoryFactoryInfoFor(Class<?> domainClass) {
        Assert.notNull(domainClass, DOMAIN_TYPE_MUST_NOT_BE_NULL);
        Class<?> userType = this.domainTypeMapping.get(ProxyUtils.getUserClass(domainClass));
        RepositoryFactoryInformation<Object, Object> repositoryInfo = this.repositoryFactoryInfos.get(userType);
        if (repositoryInfo != null) {
            return repositoryInfo;
        }
        if (!userType.equals(Object.class)) {
            return this.getRepositoryFactoryInfoFor(userType.getSuperclass());
        }
        return EMPTY_REPOSITORY_FACTORY_INFO;
    }

    public <T, S> EntityInformation<T, S> getEntityInformationFor(Class<?> domainClass) {
        Assert.notNull(domainClass, DOMAIN_TYPE_MUST_NOT_BE_NULL);
        return this.getRepositoryFactoryInfoFor(domainClass).getEntityInformation();
    }

    public Optional<RepositoryInformation> getRepositoryInformationFor(Class<?> domainClass) {
        Assert.notNull(domainClass, DOMAIN_TYPE_MUST_NOT_BE_NULL);
        RepositoryFactoryInformation<Object, Object> information = this.getRepositoryFactoryInfoFor(domainClass);
        return information == EMPTY_REPOSITORY_FACTORY_INFO ? Optional.empty() : Optional.of(information.getRepositoryInformation());
    }

    public RepositoryInformation getRequiredRepositoryInformation(Class<?> domainType) {
        return this.getRepositoryInformationFor(domainType).orElseThrow(() -> new IllegalArgumentException("No required RepositoryInformation found for domain type " + domainType.getName()));
    }

    public Optional<RepositoryInformation> getRepositoryInformation(Class<?> repositoryInterface) {
        return this.repositoryFactoryInfos.values().stream().map(RepositoryFactoryInformation::getRepositoryInformation).filter(information -> information.getRepositoryInterface().equals(repositoryInterface)).findFirst();
    }

    public PersistentEntity<?, ?> getPersistentEntity(Class<?> domainClass) {
        Assert.notNull(domainClass, DOMAIN_TYPE_MUST_NOT_BE_NULL);
        return this.getRepositoryFactoryInfoFor(domainClass).getPersistentEntity();
    }

    public List<QueryMethod> getQueryMethodsFor(Class<?> domainClass) {
        Assert.notNull(domainClass, DOMAIN_TYPE_MUST_NOT_BE_NULL);
        return this.getRepositoryFactoryInfoFor(domainClass).getQueryMethods();
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return this.repositoryFactoryInfos.keySet().iterator();
    }

    private void cacheFirstOrPrimary(Optional<ConfigurableListableBeanFactory> beanFactory, Class<?> type, RepositoryFactoryInformation information, String name) {
        Boolean presentAndPrimary;
        if (this.repositoryBeanNames.containsKey(type) && !(presentAndPrimary = beanFactory.map(it -> it.getMergedBeanDefinition(name)).map(BeanDefinition::isPrimary).orElse(false)).booleanValue()) {
            return;
        }
        this.repositoryFactoryInfos.put(type, information);
        this.repositoryBeanNames.put(type, name);
    }

    private Class<?> getRepositoryDomainTypeFor(Class<?> domainType) {
        Assert.notNull(domainType, DOMAIN_TYPE_MUST_NOT_BE_NULL);
        Set<Class<?>> declaredTypes = this.repositoryBeanNames.keySet();
        if (declaredTypes.contains(domainType)) {
            return domainType;
        }
        for (Class<?> declaredType : declaredTypes) {
            if (!declaredType.isAssignableFrom(domainType)) continue;
            return declaredType;
        }
        return domainType;
    }

    private static enum EmptyRepositoryFactoryInformation implements RepositoryFactoryInformation<Object, Object>
    {
        INSTANCE;


        @Override
        public EntityInformation<Object, Object> getEntityInformation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RepositoryInformation getRepositoryInformation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PersistentEntity<?, ?> getPersistentEntity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<QueryMethod> getQueryMethods() {
            return Collections.emptyList();
        }
    }
}

