/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Deprecated(since="3.5", forRemoval=true)
public abstract class ClassUtils {
    private ClassUtils() {
    }

    public static boolean hasProperty(Class<?> type, String property) {
        if (null != ReflectionUtils.findMethod(type, "get" + property)) {
            return true;
        }
        return null != ReflectionUtils.findField(type, StringUtils.uncapitalize(property));
    }

    public static void ifPresent(String className, @Nullable ClassLoader classLoader, Consumer<Class<?>> action) {
        org.springframework.data.util.ClassUtils.ifPresent(className, classLoader, action);
    }

    public static boolean isGenericRepositoryInterface(Class<?> interfaze) {
        return Repository.class.equals(interfaze);
    }

    public static boolean isGenericRepositoryInterface(@Nullable String interfaceName) {
        return Repository.class.getName().equals(interfaceName);
    }

    public static int getNumberOfOccurences(Method method, Class<?> type) {
        return ClassUtils.getNumberOfOccurrences(method, type);
    }

    public static int getNumberOfOccurrences(@NonNull Method method, @NonNull Class<?> parameterType) {
        return org.springframework.data.util.ReflectionUtils.getParameterCount(method, parameterType::equals);
    }

    public static void assertReturnTypeAssignable(Method method, Class<?> ... types) {
        Assert.notNull((Object)method, "Method must not be null");
        Assert.notEmpty((Object[])types, "Types must not be null or empty");
        TypeInformation<?> returnType = ClassUtils.getEffectivelyReturnedTypeFrom(method);
        Arrays.stream(types).filter(it -> it.isAssignableFrom(returnType.getType())).findAny().orElseThrow(() -> new IllegalStateException("Method has to have one of the following return types: " + Arrays.toString(types)));
    }

    public static boolean isOfType(@Nullable Object object, Collection<Class<?>> types) {
        if (object == null) {
            return false;
        }
        return types.stream().anyMatch(it -> it.isAssignableFrom(object.getClass()));
    }

    public static boolean hasParameterOfType(Method method, Class<?> type) {
        return org.springframework.data.util.ReflectionUtils.hasParameterOfType(method, type);
    }

    public static boolean hasParameterAssignableToType(Method method, Class<?> type) {
        return org.springframework.data.util.ReflectionUtils.hasParameterOfType(method, type);
    }

    public static void unwrapReflectionException(Exception ex) throws Throwable {
        if (ex instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)ex;
            ReflectionUtils.handleInvocationTargetException(ite);
        }
        throw ex;
    }

    private static TypeInformation<?> getEffectivelyReturnedTypeFrom(Method method) {
        TypeInformation<?> returnType = TypeInformation.fromReturnTypeOf(method);
        return QueryExecutionConverters.supports(returnType.getType()) || ReactiveWrapperConverters.supports(returnType.getType()) ? returnType.getRequiredComponentType() : returnType;
    }
}

