/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core;

import java.net.URI;
import java.util.function.Function;
import org.springframework.lang.Nullable;
import org.springframework.web.util.UriComponents;

public interface AggregateReference<T, ID> {
    public URI getUri();

    public AggregateReference<T, ID> withIdSource(Function<UriComponents, Object> var1);

    @Nullable
    public T resolveAggregate();

    @Nullable
    public ID resolveId();

    default public T resolveRequiredAggregate() {
        T result = this.resolveAggregate();
        if (result == null) {
            throw new IllegalStateException("Resolving the aggregate resulted in null");
        }
        return result;
    }

    default public ID resolveRequiredId() {
        ID result = this.resolveId();
        if (result == null) {
            throw new IllegalStateException("Resolving the aggregate identifier resulted in null");
        }
        return result;
    }
}

