/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core;

import java.net.URI;
import java.util.function.Function;
import org.springframework.data.rest.core.AggregateReference;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class ResolvingAggregateReference<T, ID>
implements AggregateReference<T, ID> {
    private static final Function<URI, UriComponents> STARTER = it -> UriComponentsBuilder.fromUri(it).build();
    private final URI source;
    private final Function<URI, ? extends Object> extractor;
    private final Function<Object, ? extends T> aggregateResolver;
    private final Function<Object, ? extends ID> identifierResolver;

    public ResolvingAggregateReference(URI source2, Function<Object, ? extends T> aggregateResolver, Function<Object, ? extends ID> identifierResolver) {
        this(source2, aggregateResolver, identifierResolver, it -> it);
    }

    protected ResolvingAggregateReference(URI source2, Function<Object, ? extends T> aggregateResolver, Function<Object, ? extends ID> identifierResolver, Function<URI, ? extends Object> extractor) {
        Assert.notNull((Object)source2, "Source URI must not be null!");
        Assert.notNull(aggregateResolver, "Aggregate resolver must not be null!");
        Assert.notNull(identifierResolver, "Identifier resolver must not be null!");
        this.source = source2;
        this.aggregateResolver = aggregateResolver;
        this.identifierResolver = identifierResolver;
        this.extractor = extractor;
    }

    public ResolvingAggregateReference(URI source2, @Nullable T value, ID identifier) {
        this(source2, __ -> value, __ -> identifier, it -> it);
    }

    @Override
    public URI getUri() {
        return this.source;
    }

    @Override
    public ID resolveId() {
        return this.extractor.andThen(this.identifierResolver).apply(this.source);
    }

    @Override
    public T resolveAggregate() {
        return this.extractor.andThen(this.aggregateResolver).apply(this.source);
    }

    @Override
    public AggregateReference<T, ID> withIdSource(Function<UriComponents, Object> extractor) {
        return new ResolvingAggregateReference<T, ID>(this.source, this.aggregateResolver, this.identifierResolver, STARTER.andThen(extractor));
    }
}

