/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core;

import java.net.URI;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class UriToEntityConverter
implements GenericConverter {
    private static final Class<?> ASSOCIATION_TYPE = ReflectionUtils.loadIfPresent("org.jmolecules.ddd.types.Association", UriToEntityConverter.class.getClassLoader());
    private final PersistentEntities entities;
    private final RepositoryInvokerFactory invokerFactory;
    private final Supplier<ConversionService> conversionService;
    private final Set<GenericConverter.ConvertiblePair> convertiblePairs;
    private final Set<Class<?>> identifierTypes;

    public UriToEntityConverter(PersistentEntities entities, RepositoryInvokerFactory invokerFactory, Supplier<ConversionService> conversionService) {
        Assert.notNull((Object)entities, "PersistentEntities must not be null");
        Assert.notNull((Object)invokerFactory, "RepositoryInvokerFactory must not be null");
        Assert.notNull(conversionService, "ConversionService must not be null!");
        this.convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();
        this.identifierTypes = new HashSet();
        for (TypeInformation typeInformation : entities.getManagedTypes()) {
            Class rawType = typeInformation.getType();
            Optional<PersistentEntity<?, PersistentProperty<?>>> entity = entities.getPersistentEntity(rawType);
            entity.filter(it -> it.hasIdProperty()).ifPresent(it -> {
                this.convertiblePairs.add(new GenericConverter.ConvertiblePair(URI.class, domainType.getType()));
                this.registerIdentifierType(it.getRequiredIdProperty().getType());
            });
        }
        this.entities = entities;
        this.invokerFactory = invokerFactory;
        this.conversionService = conversionService;
        if (ASSOCIATION_TYPE != null) {
            this.registerIdentifierType(ASSOCIATION_TYPE);
        }
    }

    private void registerIdentifierType(Class<?> type) {
        this.convertiblePairs.add(new GenericConverter.ConvertiblePair(URI.class, type));
        this.identifierTypes.add(type);
    }

    @Override
    @NonNull
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.convertiblePairs;
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source2 == null) {
            return null;
        }
        if (this.identifierTypes.contains(targetType.getType())) {
            String segment = UriToEntityConverter.getIdentifierSegment(source2, sourceType, targetType);
            return this.conversionService.get().convert(segment, TypeDescriptor.valueOf(String.class), targetType);
        }
        Optional<PersistentEntity<?, PersistentProperty<?>>> entity = this.entities.getPersistentEntity(targetType.getType());
        if (entity.isEmpty()) {
            throw new ConversionFailedException(sourceType, targetType, source2, new IllegalArgumentException("No PersistentEntity information available for " + String.valueOf(targetType.getType())));
        }
        String segment = UriToEntityConverter.getIdentifierSegment(source2, sourceType, targetType);
        return this.invokerFactory.getInvokerFor(targetType.getType()).invokeFindById(segment).orElse(null);
    }

    private static String getIdentifierSegment(Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
        URI uri = (URI)source2;
        String[] parts = uri.getPath().split("/");
        if (parts.length < 2) {
            throw new ConversionFailedException(sourceType, targetType, source2, new IllegalArgumentException("Cannot resolve URI " + String.valueOf(uri) + "; Is it local or remote; Only local URIs are resolvable"));
        }
        return parts[parts.length - 1];
    }
}

