/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.AbstractPropertyBindingResult;

public class ValidationErrors
extends AbstractPropertyBindingResult {
    private static final long serialVersionUID = 8141826537389141361L;
    private final Object source;
    private final PersistentEntities entities;

    public ValidationErrors(Object source2, PersistentEntities entities) {
        super(source2.getClass().getSimpleName());
        Assert.notNull(source2, "Entity must not be null");
        Assert.notNull((Object)entities, "PersistentEntities must not be null");
        this.entities = entities;
        this.source = source2;
    }

    @Override
    public ConfigurablePropertyAccessor getPropertyAccessor() {
        return new DirectFieldAccessor(this.getTarget()){

            @Override
            public Object getPropertyValue(String propertyName) throws BeansException {
                List<String> segments = Arrays.asList(propertyName.split("\\."));
                Iterator iterator2 = segments.iterator();
                Object value = ValidationErrors.this.source;
                do {
                    value = this.lookupValueOn(value, (String)iterator2.next());
                } while (iterator2.hasNext());
                return value;
            }

            @Nullable
            private Object lookupValueOn(Object value, String segment) {
                Optional<PersistentEntity<?, ? extends PersistentProperty<?>>> entity = ValidationErrors.this.entities.getPersistentEntity(value.getClass());
                return 1.getAccessor(entity, value, segment).getPropertyValue(segment);
            }

            private static ConfigurablePropertyAccessor getAccessor(Optional<PersistentEntity<?, ? extends PersistentProperty<?>>> entity, Object value, String segment) {
                if (!entity.isPresent()) {
                    return PropertyAccessorFactory.forDirectFieldAccess(value);
                }
                PersistentProperty property = entity.map(it -> it.getPersistentProperty(PropertyAccessorUtils.getPropertyName(segment))).orElseThrow(() -> new NotReadablePropertyException(value.getClass(), segment));
                return property.usePropertyAccess() ? PropertyAccessorFactory.forBeanPropertyAccess(value) : PropertyAccessorFactory.forDirectFieldAccess(value);
            }
        };
    }

    @Override
    public Object getTarget() {
        return this.source;
    }
}

