/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.config;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.data.rest.core.config.JsonSchemaFormat;
import org.springframework.util.Assert;

public class MetadataConfiguration {
    private final Map<Class<?>, JsonSchemaFormat> schemaFormats = new HashMap();
    private final Map<Class<?>, Pattern> patterns = new HashMap();
    private boolean omitUnresolvableDescriptionKeys = true;
    private boolean alpsEnabled = true;

    public void setOmitUnresolvableDescriptionKeys(boolean omitUnresolvableDescriptionKeys) {
        this.omitUnresolvableDescriptionKeys = omitUnresolvableDescriptionKeys;
    }

    public boolean omitUnresolvableDescriptionKeys() {
        return this.omitUnresolvableDescriptionKeys;
    }

    public void setAlpsEnabled(boolean enableAlps) {
        this.alpsEnabled = enableAlps;
    }

    public boolean alpsEnabled() {
        return this.alpsEnabled;
    }

    public void registerJsonSchemaFormat(JsonSchemaFormat format, Class<?> ... types) {
        Assert.notNull((Object)format, "JsonSchemaFormat must not be null");
        for (Class<?> type : types) {
            this.schemaFormats.put(type, format);
        }
    }

    public JsonSchemaFormat getSchemaFormatFor(Class<?> type) {
        return this.schemaFormats.get(type);
    }

    public void registerFormattingPatternFor(String pattern, Class<?> type) {
        Assert.hasText(pattern, "Pattern must not be null or empty");
        Assert.notNull(type, "Type must not be null");
        this.patterns.put(type, Pattern.compile(pattern));
    }

    public Pattern getPatternFor(Class<?> type) {
        Assert.notNull(type, "Type must not be null");
        for (Map.Entry<Class<?>, Pattern> entry : this.patterns.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            return entry.getValue();
        }
        return this.patterns.get(type);
    }
}

