/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.event;

import org.springframework.context.ApplicationListener;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.rest.core.event.AfterCreateEvent;
import org.springframework.data.rest.core.event.AfterDeleteEvent;
import org.springframework.data.rest.core.event.AfterLinkDeleteEvent;
import org.springframework.data.rest.core.event.AfterLinkSaveEvent;
import org.springframework.data.rest.core.event.AfterSaveEvent;
import org.springframework.data.rest.core.event.BeforeCreateEvent;
import org.springframework.data.rest.core.event.BeforeDeleteEvent;
import org.springframework.data.rest.core.event.BeforeLinkDeleteEvent;
import org.springframework.data.rest.core.event.BeforeLinkSaveEvent;
import org.springframework.data.rest.core.event.BeforeSaveEvent;
import org.springframework.data.rest.core.event.RepositoryEvent;

public abstract class AbstractRepositoryEventListener<T>
implements ApplicationListener<RepositoryEvent> {
    private final Class<?> INTERESTED_TYPE = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractRepositoryEventListener.class);

    @Override
    public final void onApplicationEvent(RepositoryEvent event) {
        Class<?> srcType = event.getSource().getClass();
        if (null != this.INTERESTED_TYPE && !this.INTERESTED_TYPE.isAssignableFrom(srcType)) {
            return;
        }
        if (event instanceof BeforeSaveEvent) {
            this.onBeforeSave(event.getSource());
        } else if (event instanceof BeforeCreateEvent) {
            this.onBeforeCreate(event.getSource());
        } else if (event instanceof AfterCreateEvent) {
            this.onAfterCreate(event.getSource());
        } else if (event instanceof AfterSaveEvent) {
            this.onAfterSave(event.getSource());
        } else if (event instanceof BeforeLinkSaveEvent) {
            this.onBeforeLinkSave(event.getSource(), ((BeforeLinkSaveEvent)event).getLinked());
        } else if (event instanceof AfterLinkSaveEvent) {
            this.onAfterLinkSave(event.getSource(), ((AfterLinkSaveEvent)event).getLinked());
        } else if (event instanceof BeforeLinkDeleteEvent) {
            this.onBeforeLinkDelete(event.getSource(), ((BeforeLinkDeleteEvent)event).getLinked());
        } else if (event instanceof AfterLinkDeleteEvent) {
            this.onAfterLinkDelete(event.getSource(), ((AfterLinkDeleteEvent)event).getLinked());
        } else if (event instanceof BeforeDeleteEvent) {
            this.onBeforeDelete(event.getSource());
        } else if (event instanceof AfterDeleteEvent) {
            this.onAfterDelete(event.getSource());
        }
    }

    protected void onBeforeCreate(T entity) {
    }

    protected void onAfterCreate(T entity) {
    }

    protected void onBeforeSave(T entity) {
    }

    protected void onAfterSave(T entity) {
    }

    protected void onBeforeLinkSave(T parent, Object linked) {
    }

    protected void onAfterLinkSave(T parent, Object linked) {
    }

    protected void onBeforeLinkDelete(T parent, Object linked) {
    }

    protected void onAfterLinkDelete(T parent, Object linked) {
    }

    protected void onBeforeDelete(T entity) {
    }

    protected void onAfterDelete(T entity) {
    }
}

