/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.annotation.Description;
import org.springframework.data.rest.core.mapping.ResolvableResourceDescriptionSupport;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AnnotationBasedResourceDescription
extends ResolvableResourceDescriptionSupport {
    private final String message;
    private final ResourceDescription fallback;

    public AnnotationBasedResourceDescription(Description description, ResourceDescription fallback) {
        Assert.notNull((Object)description, "Description must not be null");
        Assert.notNull((Object)fallback, "Fallback resource description must not be null");
        this.message = description.value();
        this.fallback = fallback;
    }

    public AnnotationBasedResourceDescription(Class<?> type, ResourceDescription fallback) {
        Description description = AnnotationUtils.findAnnotation(type, Description.class);
        this.message = description == null ? null : description.value();
        this.fallback = fallback;
    }

    @Override
    public String[] getCodes() {
        return this.fallback.getCodes();
    }

    @Override
    public String getMessage() {
        return StringUtils.hasText(this.message) ? this.message : this.fallback.getMessage();
    }

    @Override
    public MediaType getType() {
        return null;
    }

    @Override
    public boolean isDefault() {
        return !StringUtils.hasText(this.message);
    }
}

