/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.mapping.ConfigurableHttpMethods;
import org.springframework.data.rest.core.mapping.ExposureConfiguration;
import org.springframework.data.rest.core.mapping.HttpMethods;
import org.springframework.data.rest.core.mapping.PropertyAwareResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.data.rest.core.mapping.SupportedHttpMethods;
import org.springframework.util.Assert;

class ConfigurationApplyingSupportedHttpMethodsAdapter
implements SupportedHttpMethods {
    private final ExposureConfiguration configuration;
    private final ResourceMetadata resourceMetadata;
    private final SupportedHttpMethods delegate;

    ConfigurationApplyingSupportedHttpMethodsAdapter(ExposureConfiguration configuration, ResourceMetadata resourceMetadata, SupportedHttpMethods delegate) {
        Assert.notNull((Object)configuration, "Configuration must not be null");
        Assert.notNull((Object)resourceMetadata, "ResourceMetadata must not be null");
        Assert.notNull((Object)delegate, "SupportedHttpMethods must not be null");
        this.configuration = configuration;
        this.resourceMetadata = resourceMetadata;
        this.delegate = delegate;
    }

    @Override
    public HttpMethods getMethodsFor(ResourceType type) {
        HttpMethods methods = this.delegate.getMethodsFor(type);
        return this.configuration.filter(ConfigurableHttpMethods.of(methods), type, this.resourceMetadata);
    }

    @Override
    public HttpMethods getMethodsFor(PersistentProperty<?> property) {
        HttpMethods methodsFor = this.delegate.getMethodsFor(property);
        ResourceMapping mapping = this.resourceMetadata.getMappingFor(property);
        if (!PropertyAwareResourceMapping.class.isInstance(mapping)) {
            return methodsFor;
        }
        ConfigurableHttpMethods methods = ConfigurableHttpMethods.of(methodsFor);
        return this.configuration.filter(methods, (PropertyAwareResourceMapping)PropertyAwareResourceMapping.class.cast(mapping));
    }

    @Override
    public boolean allowsPutForCreation() {
        return this.configuration.allowsPutForCreation(this.resourceMetadata);
    }
}

