/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Optional;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.rest.core.annotation.RestResource;
import org.springframework.data.rest.core.mapping.HttpMethods;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.data.rest.core.mapping.SupportedHttpMethods;
import org.springframework.data.util.Lazy;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

public class CrudMethodsSupportedHttpMethods
implements SupportedHttpMethods {
    private final ExposureAwareCrudMethods exposedMethods;

    public CrudMethodsSupportedHttpMethods(CrudMethods crudMethods, boolean methodsExposedByDefault) {
        Assert.notNull((Object)crudMethods, "CrudMethods must not be null");
        this.exposedMethods = new DefaultExposureAwareCrudMethods(crudMethods, methodsExposedByDefault);
    }

    @Override
    public HttpMethods getMethodsFor(ResourceType resourceType) {
        Assert.notNull((Object)resourceType, "EntityRepresentationModel type must not be null");
        HashSet<HttpMethod> methods = new HashSet<HttpMethod>();
        methods.add(HttpMethod.OPTIONS);
        switch (resourceType) {
            case COLLECTION: {
                if (this.exposedMethods.exposesFindAll()) {
                    methods.add(HttpMethod.GET);
                    methods.add(HttpMethod.HEAD);
                }
                if (!this.exposedMethods.exposesSave()) break;
                methods.add(HttpMethod.POST);
                break;
            }
            case ITEM: {
                if (this.exposedMethods.exposesDelete()) {
                    methods.add(HttpMethod.DELETE);
                }
                if (this.exposedMethods.exposesFindOne()) {
                    methods.add(HttpMethod.GET);
                    methods.add(HttpMethod.HEAD);
                }
                if (!this.exposedMethods.exposesSave()) break;
                methods.add(HttpMethod.PUT);
                methods.add(HttpMethod.PATCH);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported resource type %s", new Object[]{resourceType}));
            }
        }
        return HttpMethods.of(methods);
    }

    @Override
    public HttpMethods getMethodsFor(PersistentProperty<?> property) {
        if (!property.isAssociation()) {
            return HttpMethods.none();
        }
        HashSet<HttpMethod> methods = new HashSet<HttpMethod>();
        methods.add(HttpMethod.GET);
        if (property.isWritable() && this.getMethodsFor(ResourceType.ITEM).contains(HttpMethod.PUT)) {
            methods.add(HttpMethod.PUT);
            methods.add(HttpMethod.PATCH);
            methods.add(HttpMethod.DELETE);
        }
        if (property.isCollectionLike() && property.isWritable()) {
            methods.add(HttpMethod.POST);
        }
        return HttpMethods.of(methods);
    }

    private static class DefaultExposureAwareCrudMethods
    implements ExposureAwareCrudMethods {
        private final Lazy<Boolean> exposesSave;
        private final Lazy<Boolean> exposesDelete;
        private final Lazy<Boolean> exposesFindOne;
        private final Lazy<Boolean> exposesFindAll;
        private final boolean exportedDefault;

        DefaultExposureAwareCrudMethods(CrudMethods crudMethods, boolean exportedDefault) {
            Assert.notNull((Object)crudMethods, "CrudMethods must not be null");
            this.exposesSave = Lazy.of(() -> this.exposes(crudMethods.getSaveMethod()));
            this.exposesDelete = Lazy.of(() -> this.exposes(crudMethods.getDeleteMethod()) && crudMethods.hasFindOneMethod());
            this.exposesFindOne = Lazy.of(() -> this.exposes(crudMethods.getFindOneMethod()));
            this.exposesFindAll = Lazy.of(() -> this.exposes(crudMethods.getFindAllMethod()));
            this.exportedDefault = exportedDefault;
        }

        @Override
        public boolean exposesSave() {
            return this.exposesSave.get();
        }

        @Override
        public boolean exposesDelete() {
            return this.exposesDelete.get();
        }

        @Override
        public boolean exposesFindOne() {
            return this.exposesFindOne.get();
        }

        @Override
        public boolean exposesFindAll() {
            return this.exposesFindAll.get();
        }

        private boolean exposes(Optional<Method> method) {
            return method.map(it -> {
                RestResource annotation = AnnotationUtils.findAnnotation(it, RestResource.class);
                return annotation == null ? this.exportedDefault : annotation.exported();
            }).orElse(false);
        }
    }

    static interface ExposureAwareCrudMethods {
        public boolean exposesSave();

        public boolean exposesDelete();

        public boolean exposesFindOne();

        public boolean exposesFindAll();
    }
}

