/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.mapping.MappingResourceMetadata;
import org.springframework.data.rest.core.mapping.PersistentPropertyResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.util.ProxyUtils;
import org.springframework.util.Assert;

public class PersistentEntitiesResourceMappings
implements ResourceMappings {
    private final PersistentEntities entities;
    private final SearchResourceMappings searchResourceMappings = new SearchResourceMappings(Collections.emptyList());
    private final Map<Class<?>, ResourceMetadata> cache = new ConcurrentHashMap();
    private final Map<Class<?>, MappingResourceMetadata> mappingCache = new ConcurrentHashMap();
    private final Map<PersistentProperty<?>, ResourceMapping> propertyCache = new ConcurrentHashMap();

    public PersistentEntitiesResourceMappings(PersistentEntities entities) {
        this.entities = entities;
    }

    @Override
    public ResourceMetadata getMetadataFor(Class<?> type) {
        Assert.notNull(type, "Type must not be null");
        return this.cache.computeIfAbsent(ProxyUtils.getUserClass(type), it -> this.getMappingMetadataFor((Class<?>)it));
    }

    MappingResourceMetadata getMappingMetadataFor(Class<?> type) {
        Assert.notNull(type, "Type must not be null");
        Class<?> userType = ProxyUtils.getUserClass(type);
        return this.mappingCache.computeIfAbsent(ProxyUtils.getUserClass(type), it -> {
            PersistentEntity entity = this.entities.getPersistentEntity(userType).orElse(null);
            return entity == null ? null : new MappingResourceMetadata(entity, this);
        });
    }

    @Override
    public SearchResourceMappings getSearchResourceMappings(Class<?> domainType) {
        return this.searchResourceMappings;
    }

    @Override
    public boolean exportsMappingFor(Class<?> type) {
        if (!this.hasMappingFor(type)) {
            return false;
        }
        ResourceMetadata metadata = this.getMetadataFor(type);
        return metadata.isExported();
    }

    @Override
    public boolean exportsTopLevelResourceFor(String path) {
        Assert.hasText(path, "Path must not be null or empty");
        for (ResourceMetadata metadata : this) {
            if (!metadata.getPath().matches(path)) continue;
            return metadata.isExported();
        }
        return false;
    }

    @Override
    public boolean hasMappingFor(Class<?> type) {
        return this.getMappingMetadataFor(type) != null;
    }

    public ResourceMapping getMappingFor(PersistentProperty<?> property) {
        return this.propertyCache.computeIfAbsent(property, it -> new PersistentPropertyResourceMapping(property, this));
    }

    public boolean isMapped(PersistentProperty<?> property) {
        ResourceMapping metadata = this.getMappingFor(property);
        return metadata != null && metadata.isExported();
    }

    @Override
    public Iterator<ResourceMetadata> iterator() {
        HashSet<ResourceMetadata> metadata = new HashSet<ResourceMetadata>();
        for (ResourceMetadata candidate : this.cache.values()) {
            if (candidate == null) continue;
            metadata.add(candidate);
        }
        return metadata.iterator();
    }

    protected final void addToCache(Class<?> type, ResourceMetadata metadata) {
        this.cache.put(type, metadata);
    }

    protected final boolean hasMetadataFor(Class<?> type) {
        return this.cache.containsKey(type);
    }
}

