/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.util.Optional;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.annotation.Description;
import org.springframework.data.rest.core.annotation.RestResource;
import org.springframework.data.rest.core.mapping.AnnotationBasedResourceDescription;
import org.springframework.data.rest.core.mapping.PropertyAwareResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.TypedResourceDescription;
import org.springframework.data.util.Optionals;
import org.springframework.hateoas.LinkRelation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class PersistentPropertyResourceMapping
implements PropertyAwareResourceMapping {
    private final PersistentProperty<?> property;
    private final ResourceMappings mappings;
    private final Optional<RestResource> annotation;
    private final Optional<Description> description;

    public PersistentPropertyResourceMapping(PersistentProperty<?> property, ResourceMappings mappings) {
        Assert.notNull(property, "PersistentProperty must not be null");
        this.property = property;
        this.mappings = mappings;
        this.annotation = Optional.ofNullable(property.isAssociation() ? property.findAnnotation(RestResource.class) : null);
        this.description = Optional.ofNullable(property.findAnnotation(Description.class));
    }

    @Override
    public Path getPath() {
        return this.annotation.filter(it -> StringUtils.hasText(it.path())).map(it -> new Path(it.path())).orElseGet(() -> new Path(this.property.getName()));
    }

    @Override
    public LinkRelation getRel() {
        return LinkRelation.of(this.annotation.filter(it -> StringUtils.hasText(it.rel())).map(it -> it.rel()).orElseGet(() -> this.property.getName()));
    }

    @Override
    public boolean isExported() {
        if (!this.property.isAssociation()) {
            return false;
        }
        ResourceMetadata typeMapping = this.mappings.getMetadataFor(this.property.getAssociationTargetType());
        return typeMapping != null && typeMapping.isExported() ? this.annotation.map(it -> it.exported()).orElse(true) : false;
    }

    @Override
    public boolean isPagingResource() {
        return false;
    }

    @Override
    public ResourceDescription getDescription() {
        ResourceMetadata ownerTypeMapping = this.mappings.getMetadataFor(this.property.getOwner().getType());
        ResourceDescription fallback = TypedResourceDescription.defaultFor(ownerTypeMapping.getItemResourceRel(), this.property);
        return Optionals.firstNonEmpty(() -> this.description.map(it -> new AnnotationBasedResourceDescription((Description)it, fallback)), () -> this.annotation.map(it -> new AnnotationBasedResourceDescription(it.description(), fallback))).orElse(fallback);
    }

    @Override
    public PersistentProperty<?> getProperty() {
        return this.property;
    }
}

