/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.lang.reflect.Modifier;
import java.util.Optional;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.annotation.Description;
import org.springframework.data.rest.core.annotation.RestResource;
import org.springframework.data.rest.core.mapping.AnnotationBasedResourceDescription;
import org.springframework.data.rest.core.mapping.CollectionResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.SimpleResourceDescription;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Optionals;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.core.EvoInflectorLinkRelationProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class TypeBasedCollectionResourceMapping
implements CollectionResourceMapping {
    private final Class<?> type;
    private final LinkRelationProvider relProvider;
    private final Optional<RestResource> annotation;
    private final Lazy<Path> path;
    private final Lazy<LinkRelation> rel;
    private final Lazy<ResourceDescription> description;
    private final Lazy<ResourceDescription> itemResourceDescription;

    public TypeBasedCollectionResourceMapping(Class<?> type) {
        this(type, new EvoInflectorLinkRelationProvider());
    }

    public TypeBasedCollectionResourceMapping(Class<?> type, LinkRelationProvider relProvider) {
        Assert.notNull(type, "Type must not be null");
        Assert.notNull((Object)relProvider, "LinkRelationProvider must not be null");
        this.type = type;
        this.relProvider = relProvider;
        this.annotation = Optional.ofNullable(AnnotationUtils.findAnnotation(type, RestResource.class));
        this.path = Lazy.of(() -> this.annotation.map(RestResource::path).map(String::trim).filter(StringUtils::hasText).orElseGet(() -> this.getDefaultPathFor(type))).map(Path::new);
        this.rel = Lazy.of(() -> this.annotation.map(RestResource::rel).filter(StringUtils::hasText).map(LinkRelation::of).orElseGet(() -> relProvider.getCollectionResourceRelFor(type)));
        Optional<Description> descriptionAnnotation = Optional.ofNullable(AnnotationUtils.findAnnotation(type, Description.class));
        this.description = Lazy.of(() -> {
            ResourceDescription fallback = SimpleResourceDescription.defaultFor(this.getRel());
            return Optionals.firstNonEmpty(() -> descriptionAnnotation.map(it -> new AnnotationBasedResourceDescription((Description)it, fallback)), () -> this.annotation.map(RestResource::description).map(it -> new AnnotationBasedResourceDescription((Description)it, fallback))).orElse(fallback);
        });
        this.itemResourceDescription = Lazy.of(() -> {
            ResourceDescription fallback = SimpleResourceDescription.defaultFor(this.getItemResourceRel());
            return Optionals.firstNonEmpty(() -> this.annotation.map(RestResource::description).filter(it -> StringUtils.hasText(it.value())).map(it -> new AnnotationBasedResourceDescription((Description)it, fallback)), () -> descriptionAnnotation.map(it -> new AnnotationBasedResourceDescription((Description)it, fallback))).orElse(fallback);
        });
    }

    @Override
    public Path getPath() {
        return this.path.get();
    }

    @Override
    public boolean isExported() {
        return this.annotation.map(RestResource::exported).orElseGet(() -> Modifier.isPublic(this.type.getModifiers()));
    }

    @Override
    public LinkRelation getRel() {
        return this.rel.get();
    }

    @Override
    public LinkRelation getItemResourceRel() {
        return this.relProvider.getItemResourceRelFor(this.type);
    }

    @Override
    public boolean isPagingResource() {
        return false;
    }

    @Override
    public ResourceDescription getDescription() {
        return this.description.get();
    }

    @Override
    public ResourceDescription getItemResourceDescription() {
        return this.itemResourceDescription.get();
    }

    @Override
    public Optional<Class<?>> getExcerptProjection() {
        return Optional.empty();
    }

    protected String getDefaultPathFor(Class<?> type) {
        return this.getSimpleTypeName(type);
    }

    private String getSimpleTypeName(Class<?> type) {
        return StringUtils.uncapitalize(type.getSimpleName());
    }
}

