/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.support;

import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.rest.core.annotation.RestResource;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.config.ResourceMapping;
import org.springframework.data.rest.core.support.ResourceStringUtils;
import org.springframework.util.StringUtils;

@Deprecated
public abstract class ResourceMappingUtils {
    protected ResourceMappingUtils() {
    }

    public static String findRel(Class<?> type) {
        RestResource anno = AnnotationUtils.findAnnotation(type, RestResource.class);
        if (anno != null && StringUtils.hasText(anno.rel())) {
            return anno.rel();
        }
        return StringUtils.uncapitalize(type.getSimpleName().replaceAll("Repository", ""));
    }

    public static String findRel(Method method) {
        RestResource anno = AnnotationUtils.findAnnotation(method, RestResource.class);
        if (anno != null && StringUtils.hasText(anno.rel())) {
            return anno.rel();
        }
        return method.getName();
    }

    public static String formatRel(RepositoryRestConfiguration config, RepositoryInformation repoInfo, PersistentProperty<?> persistentProperty) {
        if (persistentProperty == null) {
            return null;
        }
        ResourceMapping repoMapping = ResourceMappingUtils.getResourceMapping(config, repoInfo);
        ResourceMapping entityMapping = ResourceMappingUtils.getResourceMapping(config, persistentProperty.getOwner());
        ResourceMapping propertyMapping = entityMapping.getResourceMappingFor(persistentProperty.getName());
        return String.format("%s.%s.%s", repoMapping.getRel(), entityMapping.getRel(), null != propertyMapping ? propertyMapping.getRel() : persistentProperty.getName());
    }

    public static String findPath(Class<?> type) {
        RestResource anno = AnnotationUtils.findAnnotation(type, RestResource.class);
        if (anno != null && ResourceStringUtils.hasTextExceptSlash(anno.path())) {
            return ResourceStringUtils.removeLeadingSlash(anno.path());
        }
        return StringUtils.uncapitalize(type.getSimpleName().replaceAll("Repository", ""));
    }

    public static String findPath(Method method) {
        RestResource anno = AnnotationUtils.findAnnotation(method, RestResource.class);
        if (anno != null && ResourceStringUtils.hasTextExceptSlash(anno.path())) {
            return ResourceStringUtils.removeLeadingSlash(anno.path());
        }
        return method.getName();
    }

    public static boolean findExported(Class<?> type) {
        RestResource anno = AnnotationUtils.findAnnotation(type, RestResource.class);
        return anno == null || anno.exported();
    }

    public static boolean findExported(Method method) {
        RestResource anno = AnnotationUtils.findAnnotation(method, RestResource.class);
        return anno == null || anno.exported();
    }

    public static ResourceMapping getResourceMapping(RepositoryRestConfiguration config, RepositoryInformation repoInfo) {
        if (null == repoInfo) {
            return null;
        }
        Class<?> repoType = repoInfo.getRepositoryInterface();
        ResourceMapping mapping = null != config ? config.getResourceMappingForRepository(repoType) : null;
        return ResourceMappingUtils.merge(repoType, mapping);
    }

    public static ResourceMapping getResourceMapping(RepositoryRestConfiguration config, PersistentEntity<?, ?> persistentEntity) {
        if (null == persistentEntity) {
            return null;
        }
        Class<?> domainType = persistentEntity.getType();
        ResourceMapping mapping = null != config ? config.getResourceMappingForDomainType(domainType) : null;
        return ResourceMappingUtils.merge(domainType, mapping);
    }

    public static ResourceMapping merge(Method method, ResourceMapping mapping) {
        ResourceMapping defaultMapping = new ResourceMapping(ResourceMappingUtils.findRel(method), ResourceMappingUtils.findPath(method), ResourceMappingUtils.findExported(method));
        if (null != mapping) {
            return new ResourceMapping(null != mapping.getRel() ? mapping.getRel() : defaultMapping.getRel(), null != mapping.getPath() ? mapping.getPath() : defaultMapping.getPath(), mapping.isExported() != defaultMapping.isExported() ? mapping.isExported() : defaultMapping.isExported());
        }
        return defaultMapping;
    }

    public static ResourceMapping merge(Class<?> type, ResourceMapping mapping) {
        ResourceMapping defaultMapping = new ResourceMapping(ResourceMappingUtils.findRel(type), ResourceMappingUtils.findPath(type), ResourceMappingUtils.findExported(type));
        if (null != mapping) {
            return new ResourceMapping(null != mapping.getRel() ? mapping.getRel() : defaultMapping.getRel(), null != mapping.getPath() ? mapping.getPath() : defaultMapping.getPath(), mapping.isExported() != defaultMapping.isExported() ? mapping.isExported() : defaultMapping.isExported()).addResourceMappings(mapping.getResourceMappings());
        }
        return defaultMapping;
    }
}

