/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.support;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public class UnwrappingRepositoryInvokerFactory
implements RepositoryInvokerFactory {
    private final RepositoryInvokerFactory delegate;
    private final PluginRegistry<EntityLookup<?>, Class<?>> lookups;

    public UnwrappingRepositoryInvokerFactory(RepositoryInvokerFactory delegate, List<? extends EntityLookup<?>> lookups) {
        Assert.notNull((Object)delegate, "Delegate RepositoryInvokerFactory must not be null");
        Assert.notNull(lookups, "EntityLookups must not be null");
        this.delegate = delegate;
        this.lookups = PluginRegistry.of(lookups);
    }

    @Override
    public RepositoryInvoker getInvokerFor(Class<?> domainType) {
        Optional<EntityLookup<?>> lookup = this.lookups.getPluginFor(domainType);
        return new UnwrappingRepositoryInvoker(this.delegate.getInvokerFor(domainType), lookup);
    }

    private static class UnwrappingRepositoryInvoker
    implements RepositoryInvoker {
        private final RepositoryInvoker delegate;
        private final Optional<EntityLookup<?>> lookup;

        public UnwrappingRepositoryInvoker(RepositoryInvoker delegate, Optional<EntityLookup<?>> lookup) {
            Assert.notNull((Object)delegate, "Delegate RepositoryInvoker must not be null");
            Assert.notNull(lookup, "EntityLookup must not be null");
            this.delegate = delegate;
            this.lookup = lookup;
        }

        @Override
        public <T> Optional<T> invokeFindById(Object id) {
            return this.lookup.isPresent() ? this.lookup.flatMap(it -> it.lookupEntity(id)) : this.delegate.invokeFindById(id);
        }

        @Override
        public Optional<Object> invokeQueryMethod(Method method, MultiValueMap<String, ? extends Object> parameters, Pageable pageable, Sort sort) {
            return this.delegate.invokeQueryMethod(method, parameters, pageable, sort);
        }

        @Override
        public boolean hasDeleteMethod() {
            return this.delegate.hasDeleteMethod();
        }

        @Override
        public boolean hasFindAllMethod() {
            return this.delegate.hasFindAllMethod();
        }

        @Override
        public boolean hasFindOneMethod() {
            return this.delegate.hasFindOneMethod();
        }

        @Override
        public boolean hasSaveMethod() {
            return this.delegate.hasSaveMethod();
        }

        @Override
        public void invokeDeleteById(Object id) {
            this.delegate.invokeDeleteById(id);
        }

        @Override
        public Iterable<Object> invokeFindAll(Pageable pageable) {
            return this.delegate.invokeFindAll(pageable);
        }

        @Override
        public Iterable<Object> invokeFindAll(Sort sort) {
            return this.delegate.invokeFindAll(sort);
        }

        @Override
        public <T> T invokeSave(T object) {
            return this.delegate.invokeSave(object);
        }
    }
}

