/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.Optional;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class ControllerUtils {
    public static <R extends RepresentationModel<?>> ResponseEntity<RepresentationModel<?>> toResponseEntity(HttpStatus status, HttpHeaders headers, Optional<R> resource) {
        HttpHeaders hdrs = new HttpHeaders();
        if (headers != null) {
            hdrs.putAll(headers);
        }
        return new ResponseEntity((RepresentationModel)resource.orElse(null), (MultiValueMap<String, String>)hdrs, status);
    }

    public static <R extends RepresentationModel<?>> ResponseEntity<RepresentationModel<?>> toResponseEntity(HttpStatus status, HttpHeaders headers, R resource) {
        Assert.notNull((Object)status, "Http status must not be null");
        Assert.notNull((Object)headers, "Http headers must not be null");
        Assert.notNull(resource, "Payload must not be null");
        return ControllerUtils.toResponseEntity(status, headers, Optional.of(resource));
    }

    public static ResponseEntity<RepresentationModel<?>> toEmptyResponse(HttpStatus status) {
        return ControllerUtils.toEmptyResponse(status, new HttpHeaders());
    }

    public static ResponseEntity<RepresentationModel<?>> toEmptyResponse(HttpStatus status, HttpHeaders headers) {
        return ControllerUtils.toResponseEntity(status, headers, Optional.empty());
    }

    static Link getDefaultSelfLink() {
        return Link.of(ServletUriComponentsBuilder.fromCurrentRequest().build().toUriString());
    }
}

