/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.util.Assert;

public class IncomingRequest {
    private final ServerHttpRequest request;
    private final MediaType contentType;

    public IncomingRequest(ServerHttpRequest request) {
        Assert.notNull((Object)request, "ServerHttpRequest must not be null");
        this.request = request;
        this.contentType = request.getHeaders().getContentType();
    }

    public boolean isPatchRequest() {
        return this.request.getMethod().equals(HttpMethod.PATCH);
    }

    public boolean isJsonPatchRequest() {
        return this.isPatchRequest() && RestMediaTypes.JSON_PATCH_JSON.isCompatibleWith(this.contentType);
    }

    public boolean isJsonMergePatchRequest() {
        return this.isPatchRequest() && RestMediaTypes.MERGE_PATCH_JSON.isCompatibleWith(this.contentType);
    }

    public InputStream getBody() throws IOException {
        return this.request.getBody();
    }

    public ServerHttpRequest getServerHttpRequest() {
        return this.request;
    }
}

