/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.support.SelfLinkProvider;
import org.springframework.data.rest.webmvc.EmbeddedResourcesAssembler;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.support.Projector;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.core.EmbeddedWrapper;
import org.springframework.util.Assert;

public class PersistentEntityResourceAssembler
implements RepresentationModelAssembler<Object, PersistentEntityResource> {
    private final PersistentEntities entities;
    private final Projector projector;
    private final SelfLinkProvider linkProvider;
    private final EmbeddedResourcesAssembler embeddedAssembler;

    public PersistentEntityResourceAssembler(PersistentEntities entities, Projector projector, Associations associations, SelfLinkProvider linkProvider) {
        Assert.notNull((Object)entities, "PersistentEntities must not be null");
        Assert.notNull((Object)projector, "Projector must not be null");
        Assert.notNull((Object)associations, "Associations must not be null");
        Assert.notNull((Object)linkProvider, "SelfLinkProvider must not be null");
        this.entities = entities;
        this.projector = projector;
        this.linkProvider = linkProvider;
        this.embeddedAssembler = new EmbeddedResourcesAssembler(entities, associations, projector);
    }

    @Override
    public PersistentEntityResource toModel(Object instance) {
        Assert.notNull(instance, "Entity instance must not be null");
        return this.wrap(this.projector.projectExcerpt(instance), instance).build();
    }

    public PersistentEntityResource toFullResource(Object instance) {
        Assert.notNull(instance, "Entity instance must not be null");
        return this.wrap(this.projector.project(instance), instance).build();
    }

    private PersistentEntityResource.Builder wrap(Object instance, Object source2) {
        PersistentEntity<?, ? extends PersistentProperty<?>> entity = this.entities.getRequiredPersistentEntity(source2.getClass());
        return PersistentEntityResource.build(instance, entity).withEmbedded(this.getEmbeddedResources(source2)).withLink(this.getExpandedSelfLink(source2)).withLink(this.linkProvider.createSelfLinkFor(source2));
    }

    private Iterable<EmbeddedWrapper> getEmbeddedResources(Object instance) {
        return this.embeddedAssembler.getEmbeddedResources(instance);
    }

    Link getExpandedSelfLink(Object instance) {
        return this.linkProvider.createSelfLinkFor(instance).withSelfRel().expand(new Object[0]);
    }
}

