/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.ProfileController;
import org.springframework.data.rest.webmvc.RepositoryLinksResource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelProcessor;
import org.springframework.util.Assert;

public class ProfileResourceProcessor
implements RepresentationModelProcessor<RepositoryLinksResource> {
    public static final String PROFILE_REL = "profile";
    private final RepositoryRestConfiguration configuration;

    public ProfileResourceProcessor(RepositoryRestConfiguration configuration) {
        Assert.notNull((Object)configuration, "RepositoryRestConfiguration must not be null");
        this.configuration = configuration;
    }

    @Override
    public RepositoryLinksResource process(RepositoryLinksResource resource) {
        resource.add(Link.of(ProfileController.getRootPath(this.configuration), PROFILE_REL));
        return resource;
    }
}

