/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.event.AfterCreateEvent;
import org.springframework.data.rest.core.event.AfterDeleteEvent;
import org.springframework.data.rest.core.event.AfterSaveEvent;
import org.springframework.data.rest.core.event.BeforeCreateEvent;
import org.springframework.data.rest.core.event.BeforeDeleteEvent;
import org.springframework.data.rest.core.event.BeforeSaveEvent;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.core.mapping.SupportedHttpMethods;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.HttpHeadersPreparer;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.ProfileController;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.RepresentationModelAssemblers;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.ResourceStatus;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.support.BackendId;
import org.springframework.data.rest.webmvc.support.DefaultedPageable;
import org.springframework.data.rest.webmvc.support.ETag;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.UriTemplate;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RepositoryRestController
class RepositoryEntityController
implements ApplicationEventPublisherAware {
    private static final String BASE_MAPPING = "/{repository}";
    private static final List<String> ACCEPT_PATCH_HEADERS = Arrays.asList(RestMediaTypes.MERGE_PATCH_JSON.toString(), RestMediaTypes.JSON_PATCH_JSON.toString(), "application/json");
    private static final String ACCEPT_HEADER = "Accept";
    private static final String LINK_HEADER = "Link";
    private final RepositoryEntityLinks entityLinks;
    private final RepositoryRestConfiguration config;
    private final HttpHeadersPreparer headersPreparer;
    private final ResourceStatus resourceStatus;
    private ApplicationEventPublisher publisher;

    @Autowired
    public RepositoryEntityController(RepositoryRestConfiguration config, RepositoryEntityLinks entityLinks, HttpHeadersPreparer headersPreparer) {
        this.entityLinks = entityLinks;
        this.config = config;
        this.headersPreparer = headersPreparer;
        this.resourceStatus = ResourceStatus.of(headersPreparer);
    }

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @RequestMapping(value={"/{repository}"}, method={RequestMethod.OPTIONS})
    public ResponseEntity<?> optionsForCollectionResource(RootResourceInformation information) {
        HttpHeaders headers = new HttpHeaders();
        SupportedHttpMethods supportedMethods = information.getSupportedMethods();
        headers.setAllow(supportedMethods.getMethodsFor(ResourceType.COLLECTION).toSet());
        return new ResponseEntity(headers, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{repository}"}, method={RequestMethod.HEAD})
    public ResponseEntity<?> headCollectionResource(RootResourceInformation resourceInformation, DefaultedPageable pageable) throws HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.HEAD, ResourceType.COLLECTION);
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        if (null == invoker) {
            throw new ResourceNotFoundException();
        }
        Links links = Links.of(ControllerUtils.getDefaultSelfLink()).and(this.getCollectionResourceLinks(resourceInformation, pageable));
        HttpHeaders headers = new HttpHeaders();
        headers.add(LINK_HEADER, links.toString());
        return new ResponseEntity(headers, (HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}"}, method={RequestMethod.GET})
    public CollectionModel<?> getCollectionResource(@QuerydslPredicate RootResourceInformation resourceInformation, DefaultedPageable pageable, Sort sort, RepresentationModelAssemblers assemblers) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.GET, ResourceType.COLLECTION);
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        if (null == invoker) {
            throw new ResourceNotFoundException();
        }
        Iterable<Object> results = invoker.invokeFindAll(pageable.getPageable());
        ResourceMetadata metadata = resourceInformation.getResourceMetadata();
        return (CollectionModel)assemblers.toCollectionModel(results, metadata.getDomainType()).add(this.getCollectionResourceLinks(resourceInformation, pageable));
    }

    private Links getCollectionResourceLinks(RootResourceInformation resourceInformation, DefaultedPageable pageable) {
        ResourceMetadata metadata = resourceInformation.getResourceMetadata();
        SearchResourceMappings searchMappings = metadata.getSearchResourceMappings();
        Links links = Links.of(Link.of(ProfileController.getPath(this.config, metadata), "profile"));
        return searchMappings.isExported() ? links.and(this.entityLinks.linkFor(metadata.getDomainType()).slash(searchMappings.getPath()).withRel(searchMappings.getRel())) : links;
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}"}, method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json", "text/uri-list"})
    public CollectionModel<?> getCollectionResourceCompact(@QuerydslPredicate RootResourceInformation resourceinformation, DefaultedPageable pageable, Sort sort, RepresentationModelAssemblers assemblers) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        CollectionModel<?> resources = this.getCollectionResource(resourceinformation, pageable, sort, assemblers);
        Links links = resources.getContent().stream().map(PersistentEntityResource.class::cast).map(resourceinformation::resourceLink).reduce(resources.getLinks(), (rec$, xva$0) -> ((Links)rec$).and((Link)xva$0), Links::and);
        CollectionModel model = resources instanceof PagedModel ? PagedModel.empty(((PagedModel)resources).getMetadata()) : CollectionModel.empty();
        return (CollectionModel)model.add(links);
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}"}, method={RequestMethod.POST})
    public ResponseEntity<RepresentationModel<?>> postCollectionResource(RootResourceInformation resourceInformation, PersistentEntityResource payload, PersistentEntityResourceAssembler assembler, @RequestHeader(value="Accept", required=false) String acceptHeader) throws HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.POST, ResourceType.COLLECTION);
        return this.createAndReturn(payload.getContent(), resourceInformation.getInvoker(), assembler, this.config.returnBodyOnCreate(acceptHeader));
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.OPTIONS})
    public ResponseEntity<?> optionsForItemResource(RootResourceInformation information) {
        HttpHeaders headers = new HttpHeaders();
        SupportedHttpMethods supportedMethods = information.getSupportedMethods();
        headers.setAllow(supportedMethods.getMethodsFor(ResourceType.ITEM).toSet());
        headers.put("Accept-Patch", ACCEPT_PATCH_HEADERS);
        return new ResponseEntity(headers, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.HEAD})
    public ResponseEntity<?> headForItemResource(RootResourceInformation resourceInformation, @BackendId Serializable id, PersistentEntityResourceAssembler assembler) throws HttpRequestMethodNotSupportedException {
        return this.getItemResource(resourceInformation, id).map(it -> {
            Links links = assembler.toModel(it).getLinks();
            HttpHeaders headers = this.headersPreparer.prepareHeaders(resourceInformation.getPersistentEntity(), it);
            headers.add(LINK_HEADER, links.toString());
            return new ResponseEntity(headers, (HttpStatusCode)HttpStatus.NO_CONTENT);
        }).orElseThrow(() -> new ResourceNotFoundException());
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<EntityModel<?>> getItemResource(RootResourceInformation resourceInformation, @BackendId Serializable id, PersistentEntityResourceAssembler assembler, @RequestHeader HttpHeaders headers) throws HttpRequestMethodNotSupportedException {
        return this.getItemResource(resourceInformation, id).map(it -> {
            PersistentEntity<?, ?> entity = resourceInformation.getPersistentEntity();
            return this.resourceStatus.getStatusAndHeaders(headers, it, entity).toResponseEntity(() -> assembler.toFullResource(it));
        }).orElseThrow(() -> new ResourceNotFoundException());
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<? extends RepresentationModel<?>> putItemResource(RootResourceInformation resourceInformation, PersistentEntityResource payload, @BackendId Serializable id, PersistentEntityResourceAssembler assembler, ETag eTag, @RequestHeader(value="Accept", required=false) String acceptHeader) throws HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.PUT, ResourceType.ITEM);
        if (payload.isNew()) {
            resourceInformation.verifyPutForCreation();
        }
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        Object objectToSave = payload.getContent();
        eTag.verify(resourceInformation.getPersistentEntity(), objectToSave);
        return payload.isNew() ? this.createAndReturn(objectToSave, invoker, assembler, this.config.returnBodyOnCreate(acceptHeader)) : this.saveAndReturn(objectToSave, invoker, HttpMethod.PUT, assembler, this.config.returnBodyOnUpdate(acceptHeader));
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.PATCH})
    public ResponseEntity<RepresentationModel<?>> patchItemResource(RootResourceInformation resourceInformation, PersistentEntityResource payload, @BackendId Serializable id, PersistentEntityResourceAssembler assembler, ETag eTag, @RequestHeader(value="Accept", required=false) String acceptHeader) throws HttpRequestMethodNotSupportedException, ResourceNotFoundException {
        resourceInformation.verifySupportedMethod(HttpMethod.PATCH, ResourceType.ITEM);
        Object domainObject = payload.getContent();
        eTag.verify(resourceInformation.getPersistentEntity(), domainObject);
        return this.saveAndReturn(domainObject, resourceInformation.getInvoker(), HttpMethod.PATCH, assembler, this.config.returnBodyOnUpdate(acceptHeader));
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteItemResource(RootResourceInformation resourceInformation, @BackendId Serializable id, ETag eTag, PersistentEntityResourceAssembler assembler, @RequestHeader(value="Accept", required=false) String acceptHeader) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.DELETE, ResourceType.ITEM);
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        Optional<Object> domainObj = invoker.invokeFindById(id);
        return domainObj.map(it -> {
            PersistentEntity<?, ?> entity = resourceInformation.getPersistentEntity();
            eTag.verify(entity, it);
            this.publisher.publishEvent(new BeforeDeleteEvent(it));
            invoker.invokeDeleteById(entity.getIdentifierAccessor(it).getIdentifier());
            this.publisher.publishEvent(new AfterDeleteEvent(it));
            return this.config.returnBodyOnDelete(acceptHeader) ? ResponseEntity.ok(assembler.toFullResource(it)) : new ResponseEntity<PersistentEntityResource>(HttpStatus.NO_CONTENT);
        }).orElseThrow(() -> new ResourceNotFoundException());
    }

    private ResponseEntity<RepresentationModel<?>> saveAndReturn(Object domainObject, RepositoryInvoker invoker, HttpMethod httpMethod, PersistentEntityResourceAssembler assembler, boolean returnBody) {
        this.publisher.publishEvent(new BeforeSaveEvent(domainObject));
        Object obj = invoker.invokeSave(domainObject);
        this.publisher.publishEvent(new AfterSaveEvent(obj));
        PersistentEntityResource resource = assembler.toFullResource(obj);
        HttpHeaders headers = this.headersPreparer.prepareHeaders(Optional.of(resource));
        if (HttpMethod.PUT.equals(httpMethod)) {
            this.addLocationHeader(headers, assembler, obj);
        }
        if (returnBody) {
            return ControllerUtils.toResponseEntity(HttpStatus.OK, headers, resource);
        }
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT, headers);
    }

    private ResponseEntity<RepresentationModel<?>> createAndReturn(Object domainObject, RepositoryInvoker invoker, PersistentEntityResourceAssembler assembler, boolean returnBody) {
        this.publisher.publishEvent(new BeforeCreateEvent(domainObject));
        Object savedObject = invoker.invokeSave(domainObject);
        this.publisher.publishEvent(new AfterCreateEvent(savedObject));
        Optional<Object> resource = Optional.ofNullable(returnBody ? assembler.toFullResource(savedObject) : null);
        HttpHeaders headers = this.headersPreparer.prepareHeaders(resource);
        this.addLocationHeader(headers, assembler, savedObject);
        return ControllerUtils.toResponseEntity(HttpStatus.CREATED, headers, resource);
    }

    private void addLocationHeader(HttpHeaders headers, PersistentEntityResourceAssembler assembler, Object source2) {
        String selfLink = assembler.getExpandedSelfLink(source2).getHref();
        headers.setLocation(UriTemplate.of(selfLink).expand(new Object[0]));
    }

    private Optional<Object> getItemResource(RootResourceInformation resourceInformation, Serializable id) throws HttpRequestMethodNotSupportedException, ResourceNotFoundException {
        resourceInformation.verifySupportedMethod(HttpMethod.GET, ResourceType.ITEM);
        return resourceInformation.getInvoker().invokeFindById(id);
    }
}

