/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.List;
import java.util.function.Supplier;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.rest.webmvc.HttpHeadersPreparer;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.support.ETag;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

class ResourceStatus {
    private static final String INVALID_DOMAIN_OBJECT = "Domain object %s is not an instance of the given PersistentEntity of type %s";
    private final HttpHeadersPreparer preparer;

    private ResourceStatus(HttpHeadersPreparer preparer) {
        Assert.notNull((Object)preparer, "HttpHeadersPreparer must not be null");
        this.preparer = preparer;
    }

    public static ResourceStatus of(HttpHeadersPreparer preparer) {
        return new ResourceStatus(preparer);
    }

    public StatusAndHeaders getStatusAndHeaders(HttpHeaders requestHeaders, Object domainObject, PersistentEntity<?, ?> entity) {
        Assert.notNull((Object)requestHeaders, "Request headers must not be null");
        Assert.notNull(domainObject, "Domain object must not be null");
        Assert.notNull(entity, "PersistentEntity must not be null");
        Assert.isTrue(entity.getType().isInstance(domainObject), () -> String.format(INVALID_DOMAIN_OBJECT, domainObject, entity.getType()));
        List<String> ifNoneMatch = requestHeaders.getIfNoneMatch();
        ETag eTag = ifNoneMatch.isEmpty() ? ETag.NO_ETAG : ETag.from(ifNoneMatch.get(0));
        HttpHeaders responseHeaders = this.preparer.prepareHeaders(entity, domainObject);
        return eTag.matches(entity, domainObject) || this.preparer.isObjectStillValid(domainObject, requestHeaders) ? StatusAndHeaders.notModified(responseHeaders) : StatusAndHeaders.modified(responseHeaders);
    }

    public static class StatusAndHeaders {
        private final HttpHeaders headers;
        private final boolean modified;

        private StatusAndHeaders(HttpHeaders headers, boolean modified) {
            Assert.notNull((Object)headers, "HttpHeaders must not be null");
            this.headers = headers;
            this.modified = modified;
        }

        boolean isModified() {
            return this.modified;
        }

        private static StatusAndHeaders notModified(HttpHeaders headers) {
            return new StatusAndHeaders(headers, false);
        }

        private static StatusAndHeaders modified(HttpHeaders headers) {
            return new StatusAndHeaders(headers, true);
        }

        public ResponseEntity<EntityModel<?>> toResponseEntity(Supplier<PersistentEntityResource> supplier) {
            return this.modified ? new ResponseEntity<EntityModel>((EntityModel)supplier.get(), (MultiValueMap<String, String>)this.headers, HttpStatus.OK) : new ResponseEntity(this.headers, (HttpStatusCode)HttpStatus.NOT_MODIFIED);
        }
    }
}

