/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.RepositoryResourceMappings;
import org.springframework.data.rest.webmvc.HttpHeadersPreparer;
import org.springframework.data.rest.webmvc.ProfileController;
import org.springframework.data.rest.webmvc.RepositoryController;
import org.springframework.data.rest.webmvc.RepositoryEntityController;
import org.springframework.data.rest.webmvc.RepositoryPropertyReferenceController;
import org.springframework.data.rest.webmvc.RepositorySchemaController;
import org.springframework.data.rest.webmvc.RepositorySearchController;
import org.springframework.data.rest.webmvc.alps.AlpsController;
import org.springframework.data.rest.webmvc.json.PersistentEntityToJsonSchemaConverter;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;

@Configuration(proxyBeanMethods=false)
public class RestControllerConfiguration {
    private final RepositoryRestConfiguration restConfiguration;
    private final RepositoryResourceMappings resourceMappings;
    private final Repositories repositories;
    private final RepositoryEntityLinks entityLinks;

    RestControllerConfiguration(RepositoryRestConfiguration restConfiguration, RepositoryResourceMappings resourceMappings, Repositories repositories, RepositoryEntityLinks entityLinks) {
        this.restConfiguration = restConfiguration;
        this.resourceMappings = resourceMappings;
        this.repositories = repositories;
        this.entityLinks = entityLinks;
    }

    @Bean
    RepositoryController repositoryController() {
        return new RepositoryController(this.repositories, this.entityLinks, this.resourceMappings);
    }

    @Bean
    RepositoryEntityController repositoryEntityController(HttpHeadersPreparer headersPreparer) {
        return new RepositoryEntityController(this.restConfiguration, this.entityLinks, headersPreparer);
    }

    @Bean
    RepositoryPropertyReferenceController repositoryPropertyReferenceController(RepositoryInvokerFactory repositoryInvokerFactory) {
        return new RepositoryPropertyReferenceController(this.repositories, repositoryInvokerFactory);
    }

    @Bean
    RepositorySearchController repositorySearchController(HttpHeadersPreparer headersPreparer) {
        return new RepositorySearchController(this.entityLinks, this.resourceMappings, headersPreparer);
    }

    @Bean
    RepositorySchemaController repositorySchemaController(PersistentEntityToJsonSchemaConverter jsonSchemaConverter) {
        return new RepositorySchemaController(jsonSchemaConverter);
    }

    @Bean
    AlpsController alpsController() {
        return new AlpsController(this.restConfiguration);
    }

    @Bean
    ProfileController profileController() {
        return new ProfileController(this.restConfiguration, this.resourceMappings, this.repositories);
    }
}

