/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.aot;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.SpringProxy;
import org.springframework.aot.hint.ProxyHints;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.data.projection.TargetAware;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.rest.core.config.Projection;
import org.springframework.data.util.AnnotatedTypeScanner;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class ProjectionProxyAotProcessor
implements BeanRegistrationAotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectionProxyAotProcessor.class);
    private static Class<?>[] ADDITIONAL_INTERFACES = new Class[]{TargetAware.class, SpringProxy.class, DecoratingProxy.class};
    private Set<String> packagesSeen = new HashSet<String>();

    ProjectionProxyAotProcessor() {
    }

    @Override
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        if (!ClassUtils.isAssignable(RepositoryFactoryBeanSupport.class, registeredBean.getBeanClass())) {
            return null;
        }
        ConstructorArgumentValues.ValueHolder holder = registeredBean.getMergedBeanDefinition().getConstructorArgumentValues().getIndexedArgumentValue(0, String.class);
        String repositoryInterface = (String)holder.getValue();
        String packageToScan = ClassUtils.getPackageName(repositoryInterface);
        LOGGER.debug("Detecting projection interfaces in {}", (Object)packageToScan);
        if (this.packagesSeen.contains(packageToScan)) {
            return null;
        }
        this.packagesSeen.add(packageToScan);
        return (context, code) -> {
            ClassLoader classLoader = registeredBean.getBeanFactory().getBeanClassLoader();
            ProxyHints proxies = context.getRuntimeHints().proxies();
            AnnotatedTypeScanner scanner = new AnnotatedTypeScanner(Projection.class);
            scanner.setResourceLoader(new DefaultResourceLoader(classLoader));
            scanner.findTypes(packageToScan).forEach(it -> {
                LOGGER.debug("Registering proxy config for projection interface {}.", (Object)it.getName());
                proxies.registerJdkProxy(ObjectUtils.addObjectToArray(ADDITIONAL_INTERFACES, it, 0));
            });
        };
    }
}

