/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import org.springframework.data.rest.webmvc.IncomingRequest;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.data.rest.webmvc.json.BindContextFactory;
import org.springframework.data.rest.webmvc.json.DomainObjectReader;
import org.springframework.data.rest.webmvc.json.patch.BindContext;
import org.springframework.data.rest.webmvc.json.patch.JsonPatchPatchConverter;
import org.springframework.data.rest.webmvc.json.patch.Patch;
import org.springframework.data.rest.webmvc.util.InputStreamHttpInputMessage;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.Assert;

class JsonPatchHandler {
    private final BindContextFactory factory;
    private final DomainObjectReader reader;

    public JsonPatchHandler(BindContextFactory factory2, DomainObjectReader reader) {
        Assert.notNull((Object)factory2, "BindContextFactory must not be null!");
        Assert.notNull((Object)reader, "DomainObjectReader must not be null");
        this.factory = factory2;
        this.reader = reader;
    }

    public <T> T apply(IncomingRequest request, T target, ObjectMapper mapper) throws Exception {
        Assert.notNull((Object)request, "Request must not be null");
        Assert.isTrue(request.isPatchRequest(), "Cannot handle non-PATCH request");
        Assert.notNull(target, "Target must not be null");
        if (request.isJsonPatchRequest()) {
            return this.applyPatch(request.getBody(), target, mapper);
        }
        return this.applyMergePatch(request.getBody(), target, mapper);
    }

    <T> T applyPatch(InputStream source2, T target, ObjectMapper mapper) throws Exception {
        Class<?> type = target.getClass();
        BindContext context = this.factory.getBindContextFor(mapper);
        return this.getPatchOperations(source2, mapper, context).apply(target, target.getClass());
    }

    <T> T applyMergePatch(InputStream source2, T existingObject, ObjectMapper mapper) throws Exception {
        return this.reader.read(source2, existingObject, mapper);
    }

    <T> T applyPut(ObjectNode source2, T existingObject, ObjectMapper mapper) throws Exception {
        return this.reader.readPut(source2, existingObject, mapper);
    }

    private Patch getPatchOperations(InputStream source2, ObjectMapper mapper, BindContext context) {
        try {
            return new JsonPatchPatchConverter(mapper, context).convert(mapper.readTree(source2));
        }
        catch (Exception o_O) {
            throw new HttpMessageNotReadableException(String.format("Could not read PATCH operations; Expected %s", RestMediaTypes.JSON_PATCH_JSON), o_O, InputStreamHttpInputMessage.of(source2));
        }
    }
}

