/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.config.Projection;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.util.Assert;

public class ProjectionDefinitionRegistar
implements SmartInstantiationAwareBeanPostProcessor {
    private final ObjectFactory<RepositoryRestConfiguration> config;

    public ProjectionDefinitionRegistar(ObjectFactory<RepositoryRestConfiguration> config) {
        Assert.notNull(config, "RepositoryRestConfiguration must not be null");
        this.config = config;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        if (!(bean2 instanceof ResourceMappings)) {
            return bean2;
        }
        ResourceMappings mappings = (ResourceMappings)bean2;
        for (ResourceMetadata resourceMetadata : mappings) {
            Optional<Class<?>> projection = resourceMetadata.getExcerptProjection();
            projection.ifPresent(it -> {
                Class<?>[] classArray;
                Projection annotation = AnnotationUtils.findAnnotation(it, Projection.class);
                if (annotation == null) {
                    Class[] classArray2 = new Class[1];
                    classArray = classArray2;
                    classArray2[0] = resourceMetadata.getDomainType();
                } else {
                    classArray = annotation.types();
                }
                Class<?>[] target = classArray;
                this.config.getObject().getProjectionConfiguration().addProjection((Class<?>)it, target);
            });
        }
        return bean2;
    }
}

