/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.Ordered;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.auditing.MappingAuditableBeanWrapperFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.geo.GeoModule;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.querydsl.binding.QuerydslPredicateBuilder;
import org.springframework.data.repository.support.DefaultRepositoryInvokerFactory;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.StringToLdapNameConverter;
import org.springframework.data.rest.core.UriToEntityConverter;
import org.springframework.data.rest.core.config.MetadataConfiguration;
import org.springframework.data.rest.core.config.Projection;
import org.springframework.data.rest.core.config.ProjectionDefinitionConfiguration;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.event.AnnotatedEventHandlerInvoker;
import org.springframework.data.rest.core.event.ValidatingRepositoryEventListener;
import org.springframework.data.rest.core.mapping.RepositoryResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.support.DefaultSelfLinkProvider;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.data.rest.core.support.RepositoryRelProvider;
import org.springframework.data.rest.core.support.SelfLinkProvider;
import org.springframework.data.rest.core.support.UnwrappingRepositoryInvokerFactory;
import org.springframework.data.rest.webmvc.BasePathAwareHandlerMapping;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.EmbeddedResourcesAssembler;
import org.springframework.data.rest.webmvc.HttpHeadersPreparer;
import org.springframework.data.rest.webmvc.ProfileResourceProcessor;
import org.springframework.data.rest.webmvc.RepositoryRestExceptionHandler;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerAdapter;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerMapping;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.data.rest.webmvc.alps.AlpsJsonHttpMessageConverter;
import org.springframework.data.rest.webmvc.alps.RootResourceInformationToAlpsDescriptorConverter;
import org.springframework.data.rest.webmvc.config.ArgumentResolverPagingAndSortingTemplateVariables;
import org.springframework.data.rest.webmvc.config.CorsConfigurationAware;
import org.springframework.data.rest.webmvc.config.DelegatingHandlerMapping;
import org.springframework.data.rest.webmvc.config.HalFormsAdaptingResponseBodyAdvice;
import org.springframework.data.rest.webmvc.config.PersistentEntityResourceAssemblerArgumentResolver;
import org.springframework.data.rest.webmvc.config.PersistentEntityResourceHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.ProjectionDefinitionRegistar;
import org.springframework.data.rest.webmvc.config.QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.RepositoryCorsRegistry;
import org.springframework.data.rest.webmvc.config.RepositoryRestConfigurer;
import org.springframework.data.rest.webmvc.config.RepositoryRestConfigurerDelegate;
import org.springframework.data.rest.webmvc.config.RepresentationModelAssemblersArgumentResolver;
import org.springframework.data.rest.webmvc.config.ResourceMetadataHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.RestControllerImportSelector;
import org.springframework.data.rest.webmvc.config.RootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.StaticResourceProvider;
import org.springframework.data.rest.webmvc.config.StringToAggregateReferenceConverter;
import org.springframework.data.rest.webmvc.config.WebMvcRepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.convert.UriListHttpMessageConverter;
import org.springframework.data.rest.webmvc.json.AggregateReferenceResolvingModule;
import org.springframework.data.rest.webmvc.json.DomainObjectReader;
import org.springframework.data.rest.webmvc.json.EnumTranslator;
import org.springframework.data.rest.webmvc.json.Jackson2DatatypeHelper;
import org.springframework.data.rest.webmvc.json.JacksonMappingAwareSortTranslator;
import org.springframework.data.rest.webmvc.json.JacksonSerializers;
import org.springframework.data.rest.webmvc.json.MappingAwareDefaultedPageableArgumentResolver;
import org.springframework.data.rest.webmvc.json.MappingAwarePageableArgumentResolver;
import org.springframework.data.rest.webmvc.json.MappingAwareSortArgumentResolver;
import org.springframework.data.rest.webmvc.json.PersistentEntitiesBindContextFactory;
import org.springframework.data.rest.webmvc.json.PersistentEntityJackson2Module;
import org.springframework.data.rest.webmvc.json.PersistentEntityToJsonSchemaConverter;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.mapping.DefaultLinkCollector;
import org.springframework.data.rest.webmvc.mapping.LinkCollector;
import org.springframework.data.rest.webmvc.spi.BackendIdConverter;
import org.springframework.data.rest.webmvc.support.BackendIdHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.support.DefaultExcerptProjector;
import org.springframework.data.rest.webmvc.support.DomainClassResolver;
import org.springframework.data.rest.webmvc.support.ETagArgumentResolver;
import org.springframework.data.rest.webmvc.support.ExcerptProjector;
import org.springframework.data.rest.webmvc.support.HttpMethodHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.support.JpaHelper;
import org.springframework.data.rest.webmvc.support.PagingAndSortingTemplateVariables;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.data.util.AnnotatedTypeScanner;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.data.web.HateoasSortHandlerMethodArgumentResolver;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.data.web.SlicedResourcesAssembler;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.data.web.config.HateoasAwareSpringDataWebConfiguration;
import org.springframework.data.web.config.SpringDataJacksonConfiguration;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.DefaultCurieProvider;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsConfiguration;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsHttpMessageConverter;
import org.springframework.hateoas.mediatype.hal.forms.Jackson2HalFormsModule;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.core.EvoInflectorLinkRelationProvider;
import org.springframework.hateoas.server.mvc.RepresentationModelProcessorInvoker;
import org.springframework.hateoas.server.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.validation.Validator;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.util.pattern.PathPatternParser;

@Configuration(proxyBeanMethods=false)
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL, EnableHypermediaSupport.HypermediaType.HAL_FORMS})
@Import(value={RestControllerImportSelector.class, SpringDataJacksonConfiguration.class, EnableSpringDataWebSupport.QuerydslActivator.class})
public class RepositoryRestMvcConfiguration
extends HateoasAwareSpringDataWebConfiguration
implements BeanClassLoaderAware,
EmbeddedValueResolverAware {
    private static final boolean IS_JPA_AVAILABLE = ClassUtils.isPresent("jakarta.persistence.EntityManager", RepositoryRestMvcConfiguration.class.getClassLoader());
    private final ApplicationContext applicationContext;
    private final ConversionService defaultConversionService;
    private final ObjectProvider<LinkRelationProvider> relProvider;
    private final ObjectProvider<CurieProvider> curieProvider;
    private final ObjectProvider<HalConfiguration> halConfiguration;
    private final ObjectProvider<ObjectMapper> objectMapper;
    private final ObjectProvider<RepresentationModelProcessorInvoker> invoker;
    private final ObjectProvider<MessageResolver> resolver;
    private final ObjectProvider<GeoModule> geoModule;
    private final ObjectProvider<PathPatternParser> parser;
    private final Lazy<ObjectMapper> mapper;
    private final Lazy<? extends List<EntityLookup<?>>> lookups;
    private final Lazy<? extends List<HttpMessageConverter<?>>> defaultMessageConverters;
    private final Lazy<RepositoryRestConfigurerDelegate> configurerDelegate;
    private final Lazy<SelfLinkProvider> selfLinkProvider;
    private final Lazy<PersistentEntityResourceHandlerMethodArgumentResolver> persistentEntityArgumentResolver;
    private final Lazy<RootResourceInformationHandlerMethodArgumentResolver> repoRequestArgumentResolver;
    private final Lazy<BaseUri> baseUri;
    private final Lazy<RepositoryResourceMappings> resourceMappings;
    private final Lazy<Repositories> repositories;
    private final Lazy<ResourceMetadataHandlerMethodArgumentResolver> resourceMetadataHandlerMethodArgumentResolver;
    private final Lazy<ExcerptProjector> excerptProjector;
    private final Lazy<PersistentEntities> persistentEntities;
    private final Lazy<BackendIdHandlerMethodArgumentResolver> backendIdHandlerMethodArgumentResolver;
    private final Lazy<Associations> associationLinks;
    private final Lazy<EnumTranslator> enumTranslator;
    private final Lazy<ETagArgumentResolver> eTagArgumentResolver;
    private final Lazy<RepositoryInvokerFactory> repositoryInvokerFactory;
    private final Lazy<RepositoryRestConfiguration> repositoryRestConfiguration;
    private final Lazy<HateoasPageableHandlerMethodArgumentResolver> pageableResolver;
    private final Lazy<HateoasSortHandlerMethodArgumentResolver> sortResolver;
    private final Lazy<PersistentEntityResourceAssemblerArgumentResolver> persistentEntityResourceAssemblerArgumentResolver;
    private ClassLoader beanClassLoader;
    private StringValueResolver stringValueResolver;

    public RepositoryRestMvcConfiguration(ApplicationContext context, @Qualifier(value="mvcConversionService") ObjectFactory<ConversionService> conversionService, ObjectProvider<LinkRelationProvider> relProvider, ObjectProvider<CurieProvider> curieProvider, ObjectProvider<HalConfiguration> halConfiguration, ObjectProvider<ObjectMapper> objectMapper, ObjectProvider<RepresentationModelProcessorInvoker> invoker, ObjectProvider<MessageResolver> resolver, ObjectProvider<GeoModule> geoModule, ObjectProvider<PathPatternParser> parser) {
        super(context, conversionService);
        this.applicationContext = context;
        this.relProvider = relProvider;
        this.curieProvider = curieProvider;
        this.halConfiguration = halConfiguration;
        this.objectMapper = objectMapper;
        this.invoker = invoker;
        this.resolver = resolver;
        this.geoModule = geoModule;
        this.parser = parser;
        this.defaultConversionService = new DefaultFormattingConversionService();
        this.mapper = Lazy.of(() -> {
            Jdk8Module jdk8Module = new Jdk8Module();
            jdk8Module.configureAbsentsAsNulls(true);
            ObjectMapper mapper = this.basicObjectMapper();
            LinkCollector linkCollector = context.getBean(LinkCollector.class);
            mapper.registerModule(this.persistentEntityJackson2Module(linkCollector));
            mapper.registerModule(jdk8Module);
            return mapper;
        });
        this.selfLinkProvider = Lazy.of(() -> context.getBean(SelfLinkProvider.class));
        this.persistentEntityArgumentResolver = Lazy.of(() -> context.getBean(PersistentEntityResourceHandlerMethodArgumentResolver.class));
        this.repoRequestArgumentResolver = Lazy.of(() -> context.getBean(RootResourceInformationHandlerMethodArgumentResolver.class));
        this.baseUri = Lazy.of(() -> context.getBean(BaseUri.class));
        this.resourceMappings = Lazy.of(() -> context.getBean(RepositoryResourceMappings.class));
        this.repositories = Lazy.of(() -> context.getBean(Repositories.class));
        this.resourceMetadataHandlerMethodArgumentResolver = Lazy.of(() -> context.getBean(ResourceMetadataHandlerMethodArgumentResolver.class));
        this.excerptProjector = Lazy.of(() -> context.getBean(ExcerptProjector.class));
        this.persistentEntities = Lazy.of(() -> context.getBean(PersistentEntities.class));
        this.backendIdHandlerMethodArgumentResolver = Lazy.of(() -> context.getBean(BackendIdHandlerMethodArgumentResolver.class));
        this.associationLinks = Lazy.of(() -> context.getBean(Associations.class));
        this.enumTranslator = Lazy.of(() -> context.getBean(EnumTranslator.class));
        this.eTagArgumentResolver = Lazy.of(() -> context.getBean(ETagArgumentResolver.class));
        this.repositoryInvokerFactory = Lazy.of(() -> new UnwrappingRepositoryInvokerFactory(new DefaultRepositoryInvokerFactory(this.repositories.get(), this.defaultConversionService), this.getEntityLookups()));
        this.configurerDelegate = Lazy.of(() -> new RepositoryRestConfigurerDelegate(context.getBeanProvider(RepositoryRestConfigurer.class).orderedStream().collect(Collectors.toList())));
        this.repositoryRestConfiguration = Lazy.of(() -> context.getBean(RepositoryRestConfiguration.class));
        this.pageableResolver = Lazy.of(() -> context.getBean(HateoasPageableHandlerMethodArgumentResolver.class));
        this.sortResolver = Lazy.of(() -> context.getBean(HateoasSortHandlerMethodArgumentResolver.class));
        this.persistentEntityResourceAssemblerArgumentResolver = Lazy.of(() -> context.getBean(PersistentEntityResourceAssemblerArgumentResolver.class));
        this.lookups = RepositoryRestMvcConfiguration.beansOfType(context, EntityLookup.class);
        this.defaultMessageConverters = RepositoryRestMvcConfiguration.beansOfType(context, HttpMessageConverter.class);
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.stringValueResolver = resolver;
    }

    @Bean
    public Repositories repositories() {
        return new Repositories(this.applicationContext);
    }

    @Bean
    public RepositoryRelProvider repositoryRelProvider(ObjectFactory<ResourceMappings> resourceMappings) {
        return new RepositoryRelProvider(resourceMappings);
    }

    @Bean
    public PersistentEntities persistentEntities() {
        return new PersistentEntities(() -> BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, MappingContext.class).values().iterator());
    }

    @Bean
    @Qualifier
    public DefaultFormattingConversionService defaultConversionService(PersistentEntities persistentEntities, RepositoryInvokerFactory repositoryInvokerFactory) {
        DefaultFormattingConversionService conversionService = (DefaultFormattingConversionService)this.defaultConversionService;
        Supplier<ConversionService> supplier = () -> conversionService;
        conversionService.addConverter(new UriToEntityConverter(persistentEntities, repositoryInvokerFactory, supplier));
        conversionService.addConverter(new StringToAggregateReferenceConverter(supplier));
        conversionService.addConverter(StringToLdapNameConverter.INSTANCE);
        this.addFormatters(conversionService);
        this.configurerDelegate.get().configureConversionService(conversionService);
        return conversionService;
    }

    @Bean
    public ValidatingRepositoryEventListener validatingRepositoryEventListener(ObjectFactory<PersistentEntities> entities) {
        ValidatingRepositoryEventListener listener = new ValidatingRepositoryEventListener(entities);
        this.configurerDelegate.get().configureValidatingRepositoryEventListener(listener);
        return listener;
    }

    @Bean
    public JpaHelper jpaHelper() {
        if (IS_JPA_AVAILABLE) {
            return new JpaHelper();
        }
        return null;
    }

    @Bean
    public <T extends RepositoryRestConfiguration> T repositoryRestConfiguration() {
        ProjectionDefinitionConfiguration configuration = new ProjectionDefinitionConfiguration();
        for (Class<?> projection : this.getProjections(this.repositories.get())) {
            configuration.addProjection(projection);
        }
        RepositoryCorsRegistry registry = new RepositoryCorsRegistry();
        WebMvcRepositoryRestConfiguration config = new WebMvcRepositoryRestConfiguration(configuration, new MetadataConfiguration(), new EnumTranslator(MessageResolver.DEFAULTS_ONLY), registry);
        this.configurerDelegate.get().configureRepositoryRestConfiguration(config, registry);
        return (T)config;
    }

    @Bean
    public static ProjectionDefinitionRegistar projectionDefinitionRegistrar(ObjectFactory<RepositoryRestConfiguration> config) {
        return new ProjectionDefinitionRegistar(config);
    }

    @Bean
    public MetadataConfiguration metadataConfiguration() {
        return new MetadataConfiguration();
    }

    @Bean
    public BaseUri baseUri(RepositoryRestConfiguration repositoryRestConfiguration) {
        return new BaseUri(repositoryRestConfiguration.getBasePath());
    }

    @Bean
    public static AnnotatedEventHandlerInvoker annotatedEventHandlerInvoker() {
        return new AnnotatedEventHandlerInvoker();
    }

    @Bean
    public RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver(Repositories repositories, ResourceMetadataHandlerMethodArgumentResolver resourceMetadataHandlerMethodArgumentResolver, @Qualifier(value="repositoryInvokerFactory") RepositoryInvokerFactory repositoryInvokerFactory) {
        if (QuerydslUtils.QUERY_DSL_PRESENT) {
            QuerydslBindingsFactory factory2 = this.applicationContext.getBean(QuerydslBindingsFactory.class);
            QuerydslPredicateBuilder predicateBuilder = new QuerydslPredicateBuilder(this.defaultConversionService, factory2.getEntityPathResolver());
            return new QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver(repositories, repositoryInvokerFactory, resourceMetadataHandlerMethodArgumentResolver, predicateBuilder, factory2);
        }
        return new RootResourceInformationHandlerMethodArgumentResolver(repositories, repositoryInvokerFactory, resourceMetadataHandlerMethodArgumentResolver);
    }

    @Bean
    public ResourceMetadataHandlerMethodArgumentResolver resourceMetadataHandlerMethodArgumentResolver(Repositories repositories, RepositoryResourceMappings resourceMappings, BaseUri baseUri) {
        return new ResourceMetadataHandlerMethodArgumentResolver(repositories, resourceMappings, baseUri);
    }

    @Bean
    public BackendIdHandlerMethodArgumentResolver backendIdHandlerMethodArgumentResolver(PluginRegistry<BackendIdConverter, Class<?>> backendIdConverterRegistry, ResourceMetadataHandlerMethodArgumentResolver resourceMetadataHandlerMethodArgumentResolver, BaseUri baseUri) {
        return new BackendIdHandlerMethodArgumentResolver(backendIdConverterRegistry, resourceMetadataHandlerMethodArgumentResolver, baseUri);
    }

    @Bean
    public ETagArgumentResolver eTagArgumentResolver() {
        return new ETagArgumentResolver();
    }

    @Bean
    public RepositoryEntityLinks entityLinks(ObjectFactory<HateoasPageableHandlerMethodArgumentResolver> pageableResolver, Repositories repositories, RepositoryResourceMappings resourceMappings, PluginRegistry<BackendIdConverter, Class<?>> backendIdConverterRegistry, RepositoryRestConfiguration repositoryRestConfiguration, ObjectFactory<HateoasSortHandlerMethodArgumentResolver> sortResolver) {
        Lazy<Supplier<PagingAndSortingTemplateVariables>> templateVariables = Lazy.of(() -> new ArgumentResolverPagingAndSortingTemplateVariables((HateoasPageableHandlerMethodArgumentResolver)pageableResolver.getObject(), (HateoasSortHandlerMethodArgumentResolver)sortResolver.getObject()));
        return new RepositoryEntityLinks(repositories, (ResourceMappings)resourceMappings, repositoryRestConfiguration, templateVariables, backendIdConverterRegistry);
    }

    @Bean
    public PersistentEntityResourceHandlerMethodArgumentResolver persistentEntityArgumentResolver(@Qualifier(value="defaultMessageConverters") List<HttpMessageConverter<?>> defaultMessageConverters, RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver, Associations associationLinks, BackendIdHandlerMethodArgumentResolver backendIdHandlerMethodArgumentResolver, PersistentEntities entities) {
        PluginRegistry<EntityLookup<?>, Class<?>> lookups = PluginRegistry.of(this.getEntityLookups());
        DomainObjectReader reader = new DomainObjectReader(entities, associationLinks);
        PersistentEntitiesBindContextFactory factory2 = new PersistentEntitiesBindContextFactory(entities, this.defaultConversionService);
        return new PersistentEntityResourceHandlerMethodArgumentResolver(defaultMessageConverters, repoRequestArgumentResolver, backendIdHandlerMethodArgumentResolver, reader, lookups, factory2);
    }

    @Bean
    public PersistentEntityToJsonSchemaConverter jsonSchemaConverter(PersistentEntities persistentEntities, Associations associationLinks, @Qualifier(value="repositoryInvokerFactory") RepositoryInvokerFactory repositoryInvokerFactory, RepositoryRestConfiguration repositoryRestConfiguration) {
        return new PersistentEntityToJsonSchemaConverter(persistentEntities, associationLinks, this.resolver.getObject(), this.objectMapper(), repositoryRestConfiguration, new PersistentEntityToJsonSchemaConverter.ValueTypeSchemaPropertyCustomizerFactory(repositoryInvokerFactory));
    }

    public ObjectMapper objectMapper() {
        return this.mapper.get();
    }

    @Bean
    public TypeConstrainedMappingJackson2HttpMessageConverter jacksonHttpMessageConverter(RepositoryRestConfiguration repositoryRestConfiguration) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        if (!repositoryRestConfiguration.useHalAsDefaultJsonMediaType()) {
            mediaTypes.add(MediaType.APPLICATION_JSON);
        }
        int order = repositoryRestConfiguration.useHalAsDefaultJsonMediaType() ? 0x7FFFFFFE : 0x7FFFFFF5;
        mediaTypes.addAll(Arrays.asList(RestMediaTypes.SCHEMA_JSON, RestMediaTypes.JSON_PATCH_JSON, RestMediaTypes.MERGE_PATCH_JSON, RestMediaTypes.SPRING_DATA_VERBOSE_JSON, RestMediaTypes.SPRING_DATA_COMPACT_JSON));
        ResourceSupportHttpMessageConverter jacksonConverter = new ResourceSupportHttpMessageConverter(order);
        jacksonConverter.setObjectMapper(this.objectMapper());
        jacksonConverter.setSupportedMediaTypes(mediaTypes);
        return jacksonConverter;
    }

    @Bean
    public TypeConstrainedMappingJackson2HttpMessageConverter halJacksonHttpMessageConverter(LinkCollector linkCollector, RepositoryRestConfiguration repositoryRestConfiguration) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaTypes.HAL_JSON);
        mediaTypes.add(MediaTypes.VND_HAL_JSON);
        if (repositoryRestConfiguration.useHalAsDefaultJsonMediaType()) {
            mediaTypes.add(MediaType.APPLICATION_JSON);
        }
        int order = repositoryRestConfiguration.useHalAsDefaultJsonMediaType() ? 0x7FFFFFF5 : 0x7FFFFFFE;
        ResourceSupportHttpMessageConverter converter = new ResourceSupportHttpMessageConverter(order);
        converter.setObjectMapper(this.halObjectMapper(linkCollector));
        converter.setSupportedMediaTypes(mediaTypes);
        return converter;
    }

    @Bean
    TypeConstrainedMappingJackson2HttpMessageConverter halFormsJacksonHttpMessageConverter(LinkCollector linkCollector) {
        LinkRelationProvider defaultedRelProvider = this.relProvider.getIfUnique(EvoInflectorLinkRelationProvider::new);
        HalFormsConfiguration configuration = new HalFormsConfiguration(this.halConfiguration.getIfUnique(() -> new HalConfiguration()));
        CurieProvider curieProvider = this.curieProvider.getIfUnique(() -> new DefaultCurieProvider(Collections.emptyMap()));
        ObjectMapper mapper = this.basicObjectMapper();
        mapper.registerModule(this.persistentEntityJackson2Module(linkCollector));
        mapper.registerModule(new Jackson2HalFormsModule());
        mapper.setHandlerInstantiator(new Jackson2HalModule.HalHandlerInstantiator(defaultedRelProvider, curieProvider, this.resolver.getObject(), configuration.getHalConfiguration(), this.applicationContext.getAutowireCapableBeanFactory()));
        return new HalFormsHttpMessageConverter(this.applicationContext, mapper);
    }

    public ObjectMapper halObjectMapper(LinkCollector linkCollector) {
        LinkRelationProvider defaultedRelProvider = this.relProvider.getIfUnique(EvoInflectorLinkRelationProvider::new);
        HalConfiguration halConfiguration = this.halConfiguration.getIfUnique(HalConfiguration::new);
        CurieProvider curieProvider = this.curieProvider.getIfUnique(() -> new DefaultCurieProvider(Collections.emptyMap()));
        Jackson2HalModule.HalHandlerInstantiator instantiator = new Jackson2HalModule.HalHandlerInstantiator(defaultedRelProvider, curieProvider, this.resolver.getObject(), halConfiguration, this.applicationContext.getAutowireCapableBeanFactory());
        ObjectMapper mapper = this.basicObjectMapper();
        mapper.registerModule(this.persistentEntityJackson2Module(linkCollector));
        mapper.registerModule(new Jackson2HalModule());
        mapper.setHandlerInstantiator(instantiator);
        return mapper;
    }

    @Bean
    public UriListHttpMessageConverter uriListHttpMessageConverter() {
        return new UriListHttpMessageConverter();
    }

    @Bean
    public RequestMappingHandlerAdapter repositoryExporterHandlerAdapter(@Qualifier(value="mvcValidator") ObjectProvider<Validator> validator, @Qualifier(value="defaultMessageConverters") List<HttpMessageConverter<?>> defaultMessageConverters, AlpsJsonHttpMessageConverter alpsJsonHttpMessageConverter, SelfLinkProvider selfLinkProvider, PersistentEntityResourceHandlerMethodArgumentResolver persistentEntityArgumentResolver, PersistentEntityResourceAssemblerArgumentResolver persistentEntityResourceAssemblerArgumentResolver, RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver, RepositoryRestConfiguration repositoryRestConfiguration) {
        ConfigurableWebBindingInitializer initializer = new ConfigurableWebBindingInitializer();
        initializer.setConversionService(this.defaultConversionService);
        initializer.setValidator(validator.getIfUnique());
        RepositoryRestHandlerAdapter handlerAdapter = new RepositoryRestHandlerAdapter(this.defaultMethodArgumentResolvers(selfLinkProvider, persistentEntityArgumentResolver, persistentEntityResourceAssemblerArgumentResolver, repoRequestArgumentResolver));
        handlerAdapter.setWebBindingInitializer(initializer);
        handlerAdapter.setMessageConverters(defaultMessageConverters);
        ArrayList advices = new ArrayList();
        advices.add(new HalFormsAdaptingResponseBodyAdvice());
        if (repositoryRestConfiguration.getMetadataConfiguration().alpsEnabled()) {
            advices.addAll(Arrays.asList(alpsJsonHttpMessageConverter));
        }
        handlerAdapter.setResponseBodyAdvice(advices);
        return handlerAdapter;
    }

    @Bean
    public DelegatingHandlerMapping restHandlerMapping(Repositories repositories, RepositoryResourceMappings resourceMappings, Optional<JpaHelper> jpaHelper, RepositoryRestConfiguration repositoryRestConfiguration, CorsConfigurationAware corsRestConfiguration) {
        Map<String, CorsConfiguration> corsConfigurations = corsRestConfiguration.getCorsConfigurations();
        PathPatternParser parser = this.parser.getIfAvailable();
        RepositoryRestHandlerMapping repositoryMapping = new RepositoryRestHandlerMapping((ResourceMappings)resourceMappings, repositoryRestConfiguration, repositories);
        repositoryMapping.setJpaHelper(jpaHelper.orElse(null));
        repositoryMapping.setApplicationContext(this.applicationContext);
        repositoryMapping.setCorsConfigurations(corsConfigurations);
        repositoryMapping.setPatternParser(parser);
        repositoryMapping.setEmbeddedValueResolver(this.stringValueResolver);
        repositoryMapping.afterPropertiesSet();
        BasePathAwareHandlerMapping basePathMapping = new BasePathAwareHandlerMapping(repositoryRestConfiguration);
        basePathMapping.setApplicationContext(this.applicationContext);
        basePathMapping.setCorsConfigurations(corsConfigurations);
        basePathMapping.setPatternParser(parser);
        basePathMapping.setEmbeddedValueResolver(this.stringValueResolver);
        basePathMapping.afterPropertiesSet();
        ArrayList<HandlerMapping> mappings = new ArrayList<HandlerMapping>();
        mappings.add(basePathMapping);
        mappings.add(repositoryMapping);
        return new DelegatingHandlerMapping(mappings, parser);
    }

    @Bean
    public RepositoryResourceMappings resourceMappings(Repositories repositories, PersistentEntities persistentEntities, RepositoryRestConfiguration repositoryRestConfiguration) {
        return new RepositoryResourceMappings(repositories, persistentEntities, repositoryRestConfiguration);
    }

    protected Module persistentEntityJackson2Module(LinkCollector linkCollector) {
        EmbeddedResourcesAssembler assembler = new EmbeddedResourcesAssembler(this.persistentEntities.get(), this.associationLinks.get(), this.excerptProjector.get());
        PersistentEntityJackson2Module.LookupObjectSerializer lookupObjectSerializer = new PersistentEntityJackson2Module.LookupObjectSerializer(PluginRegistry.of(this.getEntityLookups()));
        return new PersistentEntityJackson2Module(this.associationLinks.get(), this.persistentEntities.get(), new UriToEntityConverter(this.persistentEntities.get(), this.repositoryInvokerFactory.get(), () -> this.defaultConversionService), linkCollector, this.repositoryInvokerFactory.get(), lookupObjectSerializer, this.invoker.getObject(), assembler);
    }

    @Bean
    protected LinkCollector linkCollector(PersistentEntities persistentEntities, SelfLinkProvider selfLinkProvider, Associations associationLinks) {
        return this.configurerDelegate.get().customizeLinkCollector(new DefaultLinkCollector(persistentEntities, selfLinkProvider, associationLinks));
    }

    @Bean
    public ExcerptProjector excerptProjector(RepositoryResourceMappings resourceMappings) {
        SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();
        projectionFactory.setBeanFactory(this.applicationContext);
        return new DefaultExcerptProjector(projectionFactory, resourceMappings);
    }

    @Override
    public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        ExceptionHandlerExceptionResolver er = new ExceptionHandlerExceptionResolver();
        er.setApplicationContext(this.applicationContext);
        er.setCustomArgumentResolvers(this.defaultMethodArgumentResolvers(this.selfLinkProvider.get(), this.persistentEntityArgumentResolver.get(), this.persistentEntityResourceAssemblerArgumentResolver.get(), this.repoRequestArgumentResolver.get()));
        er.setMessageConverters(this.defaultMessageConverters.get());
        this.configurerDelegate.get().configureExceptionHandlerExceptionResolver(er);
        er.afterPropertiesSet();
        exceptionResolvers.add(0, er);
    }

    @Bean
    public RepositoryRestExceptionHandler repositoryRestExceptionHandler() {
        return new RepositoryRestExceptionHandler(this.applicationContext);
    }

    @Bean
    @Qualifier
    public RepositoryInvokerFactory repositoryInvokerFactory() {
        return new UnwrappingRepositoryInvokerFactory(new DefaultRepositoryInvokerFactory(this.repositories.get(), this.defaultConversionService), this.getEntityLookups());
    }

    @Bean
    public List<HttpMessageConverter<?>> defaultMessageConverters(@Qualifier(value="jacksonHttpMessageConverter") TypeConstrainedMappingJackson2HttpMessageConverter jacksonHttpMessageConverter, @Qualifier(value="halJacksonHttpMessageConverter") TypeConstrainedMappingJackson2HttpMessageConverter halJacksonHttpMessageConverter, @Qualifier(value="halFormsJacksonHttpMessageConverter") TypeConstrainedMappingJackson2HttpMessageConverter halFormsJacksonHttpMessageConverter, AlpsJsonHttpMessageConverter alpsJsonHttpMessageConverter, UriListHttpMessageConverter uriListHttpMessageConverter, RepositoryRestConfiguration repositoryRestConfiguration) {
        ArrayList messageConverters = new ArrayList();
        if (repositoryRestConfiguration.getMetadataConfiguration().alpsEnabled()) {
            messageConverters.add(alpsJsonHttpMessageConverter);
        }
        if (List.of(MediaTypes.HAL_JSON, MediaTypes.VND_HAL_JSON).contains(repositoryRestConfiguration.getDefaultMediaType())) {
            messageConverters.add(halJacksonHttpMessageConverter);
            messageConverters.add(jacksonHttpMessageConverter);
        } else {
            messageConverters.add(jacksonHttpMessageConverter);
            messageConverters.add(halJacksonHttpMessageConverter);
        }
        messageConverters.add(halFormsJacksonHttpMessageConverter);
        MappingJackson2HttpMessageConverter fallbackJsonConverter = new MappingJackson2HttpMessageConverter();
        fallbackJsonConverter.setObjectMapper(this.basicObjectMapper());
        messageConverters.add(fallbackJsonConverter);
        messageConverters.add(uriListHttpMessageConverter);
        this.configurerDelegate.get().configureHttpMessageConverters(messageConverters);
        return messageConverters;
    }

    @Bean
    public AlpsJsonHttpMessageConverter alpsJsonHttpMessageConverter(RootResourceInformationToAlpsDescriptorConverter alpsConverter) {
        return new AlpsJsonHttpMessageConverter(alpsConverter);
    }

    @Override
    @Bean
    public HateoasPageableHandlerMethodArgumentResolver pageableResolver() {
        HateoasPageableHandlerMethodArgumentResolver resolver = super.pageableResolver();
        resolver.setPageParameterName(this.repositoryRestConfiguration.get().getPageParamName());
        resolver.setSizeParameterName(this.repositoryRestConfiguration.get().getLimitParamName());
        resolver.setFallbackPageable(PageRequest.of(0, this.repositoryRestConfiguration.get().getDefaultPageSize()));
        resolver.setMaxPageSize(this.repositoryRestConfiguration.get().getMaxPageSize());
        return resolver;
    }

    @Override
    @Bean
    public HateoasSortHandlerMethodArgumentResolver sortResolver() {
        HateoasSortHandlerMethodArgumentResolver resolver = super.sortResolver();
        resolver.setSortParameter(this.repositoryRestConfiguration.get().getSortParamName());
        return resolver;
    }

    @Bean
    public PluginRegistry<BackendIdConverter, Class<?>> backendIdConverterRegistry(List<BackendIdConverter> backendIdConverter) {
        ArrayList<BackendIdConverter> converters = new ArrayList<BackendIdConverter>(backendIdConverter);
        converters.add(BackendIdConverter.DefaultIdConverter.INSTANCE);
        return PluginRegistry.of(converters);
    }

    @Bean
    public AuditableBeanWrapperFactory auditableBeanWrapperFactory(PersistentEntities persistentEntities) {
        MappingAuditableBeanWrapperFactory factory2 = new MappingAuditableBeanWrapperFactory(persistentEntities);
        return this.configurerDelegate.get().customizeAuditableBeanWrapperFactory(factory2);
    }

    @Bean
    public HttpHeadersPreparer httpHeadersPreparer(AuditableBeanWrapperFactory auditableBeanWrapperFactory) {
        return new HttpHeadersPreparer(auditableBeanWrapperFactory);
    }

    @Bean
    public SelfLinkProvider selfLinkProvider(PersistentEntities persistentEntities, RepositoryEntityLinks entityLinks, @Qualifier(value="mvcConversionService") ObjectProvider<ConversionService> conversionService) {
        return new DefaultSelfLinkProvider(persistentEntities, entityLinks, this.getEntityLookups(), conversionService.getIfUnique(() -> this.defaultConversionService));
    }

    @Bean
    public Associations associationLinks(RepositoryResourceMappings resourceMappings, RepositoryRestConfiguration repositoryRestConfiguration) {
        return new Associations(resourceMappings, repositoryRestConfiguration);
    }

    protected List<EntityLookup<?>> getEntityLookups() {
        ArrayList lookups = new ArrayList();
        lookups.addAll(this.repositoryRestConfiguration.get().getEntityLookups(this.repositories.get()));
        lookups.addAll((Collection)this.lookups.get());
        return lookups;
    }

    protected List<HandlerMethodArgumentResolver> defaultMethodArgumentResolvers(SelfLinkProvider selfLinkProvider, PersistentEntityResourceHandlerMethodArgumentResolver persistentEntityArgumentResolver, PersistentEntityResourceAssemblerArgumentResolver persistentEntityResourceAssemblerArgumentResolver, RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver) {
        JacksonMappingAwareSortTranslator sortTranslator = new JacksonMappingAwareSortTranslator(this.objectMapper(), this.repositories.get(), DomainClassResolver.of(this.repositories.get(), this.resourceMappings.get(), this.baseUri.get()), this.persistentEntities.get(), this.associationLinks.get());
        return Arrays.asList(new MappingAwareDefaultedPageableArgumentResolver(sortTranslator, this.pageableResolver.get()), new MappingAwarePageableArgumentResolver(sortTranslator, this.pageableResolver.get()), new MappingAwareSortArgumentResolver(sortTranslator, this.sortResolver.get()), repoRequestArgumentResolver, persistentEntityArgumentResolver, this.resourceMetadataHandlerMethodArgumentResolver.get(), HttpMethodHandlerMethodArgumentResolver.INSTANCE, persistentEntityResourceAssemblerArgumentResolver, this.applicationContext.getBean(RepresentationModelAssemblersArgumentResolver.class), this.backendIdHandlerMethodArgumentResolver.get(), this.eTagArgumentResolver.get());
    }

    @Bean
    RepresentationModelAssemblersArgumentResolver representationModelAssemblersArgumentResolver(PagedResourcesAssembler<Object> pagedResourcesAssembler, SlicedResourcesAssembler<Object> slicedResourcesAssembler, PersistentEntityResourceAssemblerArgumentResolver delegate) {
        return new RepresentationModelAssemblersArgumentResolver(pagedResourcesAssembler, slicedResourcesAssembler, delegate);
    }

    @Bean
    PersistentEntityResourceAssemblerArgumentResolver persistentEntityResourceAssemblerArgumentResolver() {
        SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();
        projectionFactory.setBeanFactory(this.applicationContext);
        projectionFactory.setBeanClassLoader(this.beanClassLoader);
        return new PersistentEntityResourceAssemblerArgumentResolver(this.persistentEntities.get(), this.selfLinkProvider.get(), this.repositoryRestConfiguration.get().getProjectionConfiguration(), projectionFactory, this.associationLinks.get());
    }

    protected ObjectMapper basicObjectMapper() {
        ObjectMapper mapper = this.objectMapper.getIfAvailable();
        ObjectMapper objectMapper = mapper == null ? new ObjectMapper() : mapper.copy();
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.configurerDelegate.get().configureJacksonObjectMapper(objectMapper);
        objectMapper.registerModule(this.geoModule.getObject());
        objectMapper.registerModule(new AggregateReferenceResolvingModule(new UriToEntityConverter(this.persistentEntities.get(), this.repositoryInvokerFactory.get(), () -> this.defaultConversionService), this.resourceMappings.get()));
        if (this.repositoryRestConfiguration.get().isEnableEnumTranslation()) {
            objectMapper.registerModule(new JacksonSerializers(this.enumTranslator.get()));
        }
        Jackson2DatatypeHelper.configureObjectMapper(objectMapper);
        return objectMapper;
    }

    @Bean
    public EnumTranslator enumTranslator(MessageResolver resolver) {
        return new EnumTranslator(resolver);
    }

    private Set<Class<?>> getProjections(Repositories repositories) {
        HashSet<String> packagesToScan = new HashSet<String>();
        for (Class<?> domainType : repositories) {
            packagesToScan.add(domainType.getPackage().getName());
        }
        AnnotatedTypeScanner scanner = new AnnotatedTypeScanner(Projection.class);
        scanner.setEnvironment(this.applicationContext.getEnvironment());
        scanner.setResourceLoader(this.applicationContext);
        return scanner.findTypes(packagesToScan);
    }

    @Bean
    public RootResourceInformationToAlpsDescriptorConverter alpsConverter(Repositories repositories, PersistentEntities persistentEntities, RepositoryEntityLinks entityLinks, EnumTranslator enumTranslator, Associations associationLinks, RepositoryRestConfiguration repositoryRestConfiguration) {
        return new RootResourceInformationToAlpsDescriptorConverter(associationLinks, repositories, persistentEntities, entityLinks, this.resolver.getObject(), repositoryRestConfiguration, this.objectMapper(), enumTranslator);
    }

    @Bean
    public ProfileResourceProcessor profileResourceProcessor(RepositoryRestConfiguration repositoryRestConfiguration) {
        return new ProfileResourceProcessor(repositoryRestConfiguration);
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        SpringFactoriesLoader.loadFactories(StaticResourceProvider.class, this.beanClassLoader).forEach(it -> it.customizeResources(registry, this.repositoryRestConfiguration.get()));
    }

    private static <S> Lazy<List<S>> beansOfType(ApplicationContext context, Class<?> type) {
        return Lazy.of(() -> context.getBeanProvider(type).orderedStream().collect(StreamUtils.toUnmodifiableList()));
    }

    private static class ResourceSupportHttpMessageConverter
    extends TypeConstrainedMappingJackson2HttpMessageConverter
    implements Ordered {
        private final int order;

        public ResourceSupportHttpMessageConverter(int order) {
            super(RepresentationModel.class);
            this.order = order;
        }

        @Override
        public int getOrder() {
            return this.order;
        }
    }
}

