/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import java.util.ArrayList;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.rest.webmvc.RestControllerConfiguration;
import org.springframework.data.rest.webmvc.config.JMoleculesConfigurer;
import org.springframework.util.ClassUtils;

class RestControllerImportSelector
implements ImportSelector {
    private static final String HAL_EXPLORER_CONFIGURATION = "org.springframework.data.rest.webmvc.halexplorer.HalExplorerConfiguration";
    private static final String JMOLECULES_SPRING = "org.jmolecules.spring.IdentifierToPrimitivesConverter";

    RestControllerImportSelector() {
    }

    @Override
    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        ArrayList<String> configurations = new ArrayList<String>();
        configurations.add(RestControllerConfiguration.class.getName());
        ClassLoader classLoader = importingClassMetadata.getClass().getClassLoader();
        if (ClassUtils.isPresent(HAL_EXPLORER_CONFIGURATION, classLoader)) {
            configurations.add(HAL_EXPLORER_CONFIGURATION);
        }
        if (ClassUtils.isPresent(JMOLECULES_SPRING, classLoader)) {
            configurations.add(JMoleculesConfigurer.class.getName());
        }
        return configurations.toArray(new String[configurations.size()]);
    }
}

