/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jmolecules.ddd.types.AggregateRoot;
import org.jmolecules.ddd.types.Identifier;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.rest.core.AggregateReference;
import org.springframework.data.rest.core.AssociationAggregateReference;
import org.springframework.data.rest.core.ResolvingAggregateReference;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.util.UriComponents;

class StringToAggregateReferenceConverter
implements GenericConverter {
    private static final boolean JMOLECULES_PRESENT = ClassUtils.isPresent("org.jmolecules.spring.IdentifierToPrimitivesConverter", StringToAggregateReferenceConverter.class.getClassLoader());
    private static final Class<?> ASSOCIATION_AGGREGATE_REFERENCE_TYPE = StringToAggregateReferenceConverter.tryToLoadAssociationReferenceClass();
    private final Supplier<ConversionService> conversionService;

    StringToAggregateReferenceConverter(Supplier<ConversionService> conversionService) {
        Assert.notNull(conversionService, "ConversionService must not be null!");
        this.conversionService = conversionService;
    }

    private static Class<?> tryToLoadAssociationReferenceClass() {
        ClassLoader classLoader = StringToAggregateReferenceConverter.class.getClassLoader();
        if (!ClassUtils.isPresent("org.jmolecules.ddd.types.Association", classLoader)) {
            return null;
        }
        try {
            return ClassUtils.forName("org.springframework.data.rest.core.AssociationAggregateReference", classLoader);
        }
        catch (ClassNotFoundException o_O) {
            return null;
        }
    }

    @Override
    @NonNull
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Set.of(new GenericConverter.ConvertiblePair(String.class, AggregateReference.class));
    }

    @Override
    @NonNull
    public AggregateReference<?, ?> convert(@Nullable Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source2 == null) {
            throw new ConversionFailedException(sourceType, targetType, source2, new IllegalArgumentException("Source value must not be null"));
        }
        try {
            URI uri = new URI(source2.toString());
            ResolvableType resolvableType = targetType.getResolvableType();
            TypeDescriptor aggregateDescriptor = new TypeDescriptor(resolvableType.getGeneric(0), null, targetType.getAnnotations());
            TypeDescriptor identifierDescriptor = new TypeDescriptor(resolvableType.getGeneric(1), null, targetType.getAnnotations());
            Function<Object, Object> aggregateResolver = it -> this.conversionService.get().convert(it, sourceType, aggregateDescriptor);
            Function<Object, Object> identifierResolver = it -> this.conversionService.get().convert(it, sourceType, identifierDescriptor);
            ResolvingAggregateReference<Function<Object, Object>, Function<Object, Object>> result = new ResolvingAggregateReference<Function<Object, Object>, Function<Object, Object>>(uri, aggregateResolver, identifierResolver);
            return JMOLECULES_PRESENT && resolvableType.toClass().equals(ASSOCIATION_AGGREGATE_REFERENCE_TYPE) ? StringToAggregateReferenceConverter.withJMolecules(result) : result;
        }
        catch (URISyntaxException e) {
            throw new ConversionFailedException(sourceType, targetType, source2, e);
        }
    }

    private static AggregateReference<?, ?> withJMolecules(AggregateReference<?, ?> source2) {
        return new ResolvingAssociationAggregateReference(source2);
    }

    private static class ResolvingAssociationAggregateReference<T extends AggregateRoot<T, ID>, ID extends Identifier>
    implements AssociationAggregateReference<T, ID> {
        private AggregateReference<T, ID> delegate;

        ResolvingAssociationAggregateReference(AggregateReference<T, ID> delegate) {
            this.delegate = delegate;
        }

        @Override
        public URI getUri() {
            return this.delegate.getUri();
        }

        @Override
        public ID resolveId() {
            return (ID)((Identifier)this.delegate.resolveId());
        }

        @Override
        public T resolveAggregate() {
            return (T)((AggregateRoot)this.delegate.resolveAggregate());
        }

        @Override
        public AssociationAggregateReference<T, ID> withIdSource(Function<UriComponents, Object> extractor) {
            return new ResolvingAssociationAggregateReference<T, ID>(this.delegate.withIdSource(extractor));
        }
    }
}

