/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.hibernate6.Hibernate6Module;
import org.springframework.util.ClassUtils;

public class Jackson2DatatypeHelper {
    private static final boolean IS_HIBERNATE_AVAILABLE = ClassUtils.isPresent("org.hibernate.Version", Jackson2DatatypeHelper.class.getClassLoader());
    private static final boolean IS_HIBERNATE6_MODULE_AVAILABLE = ClassUtils.isPresent("com.fasterxml.jackson.datatype.hibernate6.Hibernate6Module", Jackson2DatatypeHelper.class.getClassLoader());

    public static void configureObjectMapper(ObjectMapper mapper) {
        if (IS_HIBERNATE_AVAILABLE && IS_HIBERNATE6_MODULE_AVAILABLE) {
            new Hibernate6ModuleRegistrar().registerModule(mapper);
        }
    }

    private static class Hibernate6ModuleRegistrar {
        private Hibernate6ModuleRegistrar() {
        }

        public void registerModule(ObjectMapper mapper) {
            Hibernate6Module module = new Hibernate6Module();
            module.enable(Hibernate6Module.Feature.FORCE_LAZY_LOADING);
            mapper.registerModule((Module)module);
        }
    }
}

