/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.webmvc.json.JacksonMappingAwareSortTranslator;
import org.springframework.data.web.PageableArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class MappingAwarePageableArgumentResolver
implements HandlerMethodArgumentResolver,
PageableArgumentResolver {
    private final JacksonMappingAwareSortTranslator translator;
    private final PageableArgumentResolver delegate;

    public MappingAwarePageableArgumentResolver(JacksonMappingAwareSortTranslator translator, PageableArgumentResolver delegate) {
        Assert.notNull((Object)translator, "JacksonMappingAwareSortTranslator must not be null");
        Assert.notNull((Object)delegate, "Delegate PageableArgumentResolver must not be null");
        this.translator = translator;
        this.delegate = delegate;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.delegate.supportsParameter(parameter);
    }

    @Override
    public Pageable resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        Pageable pageable = this.delegate.resolveArgument(methodParameter, mavContainer, webRequest, binderFactory);
        if (pageable.isUnpaged() || pageable.getSort().isUnsorted()) {
            return pageable;
        }
        Sort translated = this.translator.translateSort(pageable.getSort(), methodParameter, webRequest);
        return PageRequest.of(pageable.getPageNumber(), pageable.getPageSize(), translated);
    }
}

