/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.JsonValueSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.projection.TargetAware;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.UriToEntityConverter;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.data.rest.webmvc.EmbeddedResourcesAssembler;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.json.MappedProperties;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.mapping.LinkCollector;
import org.springframework.data.util.CastUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.server.mvc.RepresentationModelProcessorInvoker;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class PersistentEntityJackson2Module
extends SimpleModule {
    private static final long serialVersionUID = -7289265674870906323L;
    private static final Logger LOG = LoggerFactory.getLogger(PersistentEntityJackson2Module.class);
    private static final TypeDescriptor URI_DESCRIPTOR = TypeDescriptor.valueOf(URI.class);

    public PersistentEntityJackson2Module(Associations associations, PersistentEntities entities, UriToEntityConverter converter, LinkCollector collector, RepositoryInvokerFactory factory2, LookupObjectSerializer lookupObjectSerializer, RepresentationModelProcessorInvoker invoker, EmbeddedResourcesAssembler assembler) {
        super("persistent-entity-resource", new Version(2, 0, 0, null, "org.springframework.data.rest", "jackson-module"));
        Assert.notNull((Object)associations, "AssociationLinks must not be null");
        Assert.notNull((Object)entities, "Repositories must not be null");
        Assert.notNull((Object)converter, "UriToEntityConverter must not be null");
        Assert.notNull((Object)collector, "LinkCollector must not be null");
        NestedEntitySerializer serializer = new NestedEntitySerializer(entities, assembler, invoker);
        this.addSerializer(new PersistentEntityResourceSerializer(collector));
        this.addSerializer(new ProjectionSerializer(collector, associations, invoker, false));
        this.addSerializer(new ProjectionResourceContentSerializer(false));
        this.setSerializerModifier(new AssociationOmittingSerializerModifier(entities, associations, serializer, lookupObjectSerializer));
        this.setDeserializerModifier(new AssociationUriResolvingDeserializerModifier(entities, associations, converter, factory2));
    }

    static class NestedEntitySerializer
    extends StdSerializer<Object> {
        private static final long serialVersionUID = -2327469118972125954L;
        private final PersistentEntities entities;
        private final EmbeddedResourcesAssembler assembler;
        private final RepresentationModelProcessorInvoker invoker;

        public NestedEntitySerializer(PersistentEntities entities, EmbeddedResourcesAssembler assembler, RepresentationModelProcessorInvoker invoker) {
            super(Object.class);
            this.entities = entities;
            this.assembler = assembler;
            this.invoker = invoker;
        }

        @Override
        public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value instanceof Collection) {
                Collection source2 = (Collection)value;
                ArrayList<Object> resources = new ArrayList<Object>();
                for (Object element : source2) {
                    resources.add(this.toModel(element, provider));
                }
                provider.defaultSerializeValue(resources, gen);
            } else if (value instanceof Map) {
                Map source3 = (Map)value;
                Map resources = CollectionFactory.createApproximateMap(value.getClass(), source3.size());
                for (Map.Entry entry : source3.entrySet()) {
                    resources.put(entry.getKey(), this.toModel(entry.getValue(), provider));
                }
                provider.defaultSerializeValue(resources, gen);
            } else {
                provider.defaultSerializeValue(this.toModel(value, provider), gen);
            }
        }

        @Override
        public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSerializer) throws IOException {
            this.serialize(value, gen, provider);
        }

        private Object toModel(Object value, SerializerProvider provider) throws JsonMappingException {
            JsonSerializer<Object> serializer = provider.findValueSerializer(value.getClass());
            if (JsonValueSerializer.class.isInstance(serializer)) {
                return value;
            }
            JsonSerializer<Object> unwrappingSerializer = serializer.unwrappingSerializer(NameTransformer.NOP);
            if (!unwrappingSerializer.isUnwrappingSerializer()) {
                return value;
            }
            PersistentEntity<?, ? extends PersistentProperty<?>> entity = this.entities.getRequiredPersistentEntity(value.getClass());
            return this.invoker.invokeProcessorsFor(PersistentEntityResource.build(value, entity).withEmbedded(this.assembler.getEmbeddedResources(value)).buildNested());
        }
    }

    private static class PersistentEntityResourceSerializer
    extends StdSerializer<PersistentEntityResource> {
        private final LinkCollector collector;

        private PersistentEntityResourceSerializer(LinkCollector collector) {
            super(PersistentEntityResource.class);
            this.collector = collector;
        }

        @Override
        public void serialize(final PersistentEntityResource resource, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            LOG.debug("Serializing PersistentEntity {}", (Object)resource.getPersistentEntity());
            Object content = resource.getContent();
            if (PersistentEntityResourceSerializer.hasScalarSerializer(content, provider)) {
                provider.defaultSerializeValue(content, jgen);
                return;
            }
            Links links = this.getLinks(resource);
            if (TargetAware.class.isInstance(content)) {
                TargetAware targetAware = (TargetAware)content;
                provider.defaultSerializeValue(new ProjectionResource(targetAware, (Iterable<Link>)links), jgen);
                return;
            }
            EntityModel<Object> resourceToRender = new EntityModel<Object>(resource.getContent(), (Iterable)links){

                @JsonUnwrapped
                public Iterable<?> getEmbedded() {
                    return resource.getEmbeddeds();
                }
            };
            provider.defaultSerializeValue(resourceToRender, jgen);
        }

        private Links getLinks(PersistentEntityResource resource) {
            Object source2 = this.getLinkSource(resource.getContent());
            return resource.isNested() ? this.collector.getLinksForNested(source2, resource.getLinks()) : this.collector.getLinksFor(source2, resource.getLinks());
        }

        private Object getLinkSource(Object object) {
            return TargetAware.class.isInstance(object) ? ((TargetAware)object).getTarget() : object;
        }

        private static boolean hasScalarSerializer(Object source2, SerializerProvider provider) throws JsonMappingException {
            JsonSerializer<Object> serializer = provider.findValueSerializer(source2.getClass());
            return serializer instanceof ToStringSerializer || serializer instanceof StdScalarSerializer;
        }
    }

    static class ProjectionSerializer
    extends StdSerializer<TargetAware> {
        private final LinkCollector collector;
        private final Associations associations;
        private final RepresentationModelProcessorInvoker invoker;
        private final boolean unwrapping;

        ProjectionSerializer(LinkCollector collector, Associations mappings, RepresentationModelProcessorInvoker invoker, boolean unwrapping) {
            super(TargetAware.class);
            this.collector = collector;
            this.associations = mappings;
            this.invoker = invoker;
            this.unwrapping = unwrapping;
        }

        @Override
        public void serialize(TargetAware value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (!this.unwrapping) {
                jgen.writeStartObject();
            }
            provider.findValueSerializer(ProjectionResource.class, null).unwrappingSerializer(null).serialize(this.toModel(value), jgen, provider);
            if (!this.unwrapping) {
                jgen.writeEndObject();
            }
        }

        @Override
        public boolean isUnwrappingSerializer() {
            return this.unwrapping;
        }

        @Override
        public JsonSerializer<TargetAware> unwrappingSerializer(NameTransformer unwrapper) {
            return new ProjectionSerializer(this.collector, this.associations, this.invoker, true);
        }

        ProjectionResource toModel(TargetAware value) {
            Object target = value.getTarget();
            ResourceMetadata metadata = this.associations.getMetadataFor(value.getTargetClass());
            Links links = metadata != null && metadata.isExported() ? this.collector.getLinksFor(target) : Links.NONE;
            EntityModel<TargetAware> resource = this.invoker.invokeProcessorsFor(EntityModel.of(value, links));
            return new ProjectionResource(resource.getContent(), (Iterable<Link>)resource.getLinks());
        }
    }

    private static class ProjectionResourceContentSerializer
    extends StdSerializer<ProjectionResourceContent> {
        private final boolean unwrapping;

        public ProjectionResourceContentSerializer(boolean unwrapping) {
            super(ProjectionResourceContent.class);
            this.unwrapping = unwrapping;
        }

        @Override
        public void serialize(ProjectionResourceContent value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            provider.findValueSerializer(value.getProjectionInterface(), null).unwrappingSerializer(null).serialize(value.getProjection(), jgen, provider);
        }

        @Override
        public boolean isUnwrappingSerializer() {
            return this.unwrapping;
        }

        @Override
        public JsonSerializer<ProjectionResourceContent> unwrappingSerializer(NameTransformer unwrapper) {
            return new ProjectionResourceContentSerializer(true);
        }
    }

    static class AssociationOmittingSerializerModifier
    extends BeanSerializerModifier {
        private final PersistentEntities entities;
        private final Associations associations;
        private final NestedEntitySerializer nestedEntitySerializer;
        private final LookupObjectSerializer lookupObjectSerializer;

        public AssociationOmittingSerializerModifier(PersistentEntities entities, Associations associations, NestedEntitySerializer nestedEntitySerializer, LookupObjectSerializer lookupObjectSerializer) {
            Assert.notNull((Object)entities, "PersistentEntities must not be null");
            Assert.notNull((Object)associations, "Associations must not be null");
            Assert.notNull((Object)nestedEntitySerializer, "NestedEntitySerializer must not be null");
            Assert.notNull((Object)lookupObjectSerializer, "LookupObjectSerializer must not be null");
            this.entities = entities;
            this.associations = associations;
            this.nestedEntitySerializer = nestedEntitySerializer;
            this.lookupObjectSerializer = lookupObjectSerializer;
        }

        @Override
        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
            return this.entities.getPersistentEntity(beanDesc.getBeanClass()).map(entity -> {
                ArrayList<BeanPropertyWriter> result = new ArrayList<BeanPropertyWriter>();
                for (BeanPropertyWriter writer : beanProperties) {
                    Optional<PersistentProperty<?>> findProperty = this.findProperty(writer.getName(), (PersistentEntity<?, ? extends PersistentProperty<?>>)entity, beanDesc);
                    if (!findProperty.isPresent()) {
                        result.add(writer);
                        continue;
                    }
                    findProperty.flatMap(it -> {
                        if (this.associations.isLookupType((PersistentProperty<?>)it)) {
                            LOG.debug("Assigning lookup object serializer for {}", it);
                            writer.assignSerializer(this.lookupObjectSerializer);
                            return Optional.of(writer);
                        }
                        if (this.associations.isLinkableAssociation((PersistentProperty<?>)it)) {
                            return Optional.empty();
                        }
                        if (it.isIdProperty() && !this.associations.isIdExposed((PersistentEntity<?, ?>)entity)) {
                            return Optional.empty();
                        }
                        if (it.isVersionProperty()) {
                            return Optional.empty();
                        }
                        if (it.isEntity() && !writer.isUnwrapping()) {
                            LOG.debug("Assigning nested entity serializer for {}", it);
                            writer.assignSerializer(this.nestedEntitySerializer);
                        }
                        return Optional.of(writer);
                    }).ifPresent(result::add);
                }
                return result;
            }).orElse(beanProperties);
        }

        private Optional<? extends PersistentProperty<?>> findProperty(String finalName, PersistentEntity<?, ? extends PersistentProperty<?>> entity, BeanDescription description) {
            return description.findProperties().stream().filter(it -> it.getName().equals(finalName)).findFirst().map(it -> entity.getPersistentProperty(it.getInternalName()));
        }
    }

    public static class LookupObjectSerializer
    extends ToStringSerializer {
        private static final long serialVersionUID = -3033458643050330913L;
        private final PluginRegistry<EntityLookup<?>, Class<?>> lookups;

        public LookupObjectSerializer(PluginRegistry<EntityLookup<?>, Class<?>> lookups) {
            Assert.notNull(lookups, "EntityLookups must not be null");
            this.lookups = lookups;
        }

        @Override
        public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value instanceof Collection) {
                gen.writeStartArray();
                for (Object element : (Collection)value) {
                    gen.writeObject(this.getLookupKey(element));
                }
                gen.writeEndArray();
            } else {
                gen.writeObject(this.getLookupKey(value));
            }
        }

        private Object getLookupKey(Object value) {
            return this.lookups.getPluginFor(value.getClass()).map(CastUtils::cast).orElseThrow(() -> new IllegalArgumentException("No EntityLookup found for " + value.getClass().getName())).getResourceIdentifier(value);
        }
    }

    public static class AssociationUriResolvingDeserializerModifier
    extends BeanDeserializerModifier {
        private final PersistentEntities entities;
        private final Associations associationLinks;
        private final UriToEntityConverter converter;
        private final RepositoryInvokerFactory factory;

        public AssociationUriResolvingDeserializerModifier(PersistentEntities entities, Associations associations, UriToEntityConverter converter, RepositoryInvokerFactory factory2) {
            Assert.notNull((Object)entities, "PersistentEntities must not be null");
            Assert.notNull((Object)associations, "Associations must not be null");
            Assert.notNull((Object)converter, "UriToEntityConverter must not be null");
            Assert.notNull((Object)factory2, "RepositoryInvokerFactory must not be null");
            this.entities = entities;
            this.associationLinks = associations;
            this.converter = converter;
            this.factory = factory2;
        }

        @Override
        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
            ValueInstantiatorCustomizer customizer2 = new ValueInstantiatorCustomizer(builder.getValueInstantiator(), config);
            Iterator<SettableBeanProperty> properties = builder.getProperties();
            this.entities.getPersistentEntity(beanDesc.getBeanClass()).ifPresent(entity -> {
                MappedProperties mapped = MappedProperties.forDescription(entity, beanDesc);
                while (properties.hasNext()) {
                    SettableBeanProperty property = (SettableBeanProperty)properties.next();
                    PersistentProperty<?> persistentProperty = mapped.getPersistentProperty(property.getName());
                    if (persistentProperty == null) continue;
                    TypeInformation<?> propertyType = persistentProperty.getTypeInformation();
                    if (this.associationLinks.isLookupType(persistentProperty)) {
                        RepositoryInvokingDeserializer repositoryInvokingDeserializer = new RepositoryInvokingDeserializer(this.factory, persistentProperty);
                        JsonDeserializer<?> deserializer = AssociationUriResolvingDeserializerModifier.wrapIfCollection(propertyType, repositoryInvokingDeserializer, config);
                        builder.addOrReplaceProperty(property.withValueDeserializer(deserializer), false);
                        continue;
                    }
                    if (!this.associationLinks.isLinkableAssociation(persistentProperty)) continue;
                    Class<?> actualPropertyType = persistentProperty.getActualType();
                    UriStringDeserializer uriStringDeserializer = new UriStringDeserializer(actualPropertyType, this.converter);
                    JsonDeserializer<?> deserializer = AssociationUriResolvingDeserializerModifier.wrapIfCollection(propertyType, uriStringDeserializer, config);
                    customizer2.replacePropertyIfNeeded(builder, property.withValueDeserializer(deserializer));
                }
            });
            return customizer2.conclude(builder);
        }

        private static JsonDeserializer<?> wrapIfCollection(TypeInformation<?> property, JsonDeserializer<Object> elementDeserializer, DeserializationConfig config) {
            if (!property.isCollectionLike()) {
                return elementDeserializer;
            }
            CollectionLikeType collectionType = config.getTypeFactory().constructCollectionLikeType(property.getType(), property.getActualType().getType());
            CollectionValueInstantiator instantiator = new CollectionValueInstantiator(property);
            return new CollectionDeserializer(collectionType, elementDeserializer, null, instantiator);
        }

        public static class ValueInstantiatorCustomizer {
            public static final Field CONSTRUCTOR_ARGS_FIELD = ReflectionUtils.findField(StdValueInstantiator.class, "_constructorArguments");
            private final SettableBeanProperty[] properties;
            private final StdValueInstantiator instantiator;

            ValueInstantiatorCustomizer(ValueInstantiator instantiator, DeserializationConfig config) {
                this.instantiator = StdValueInstantiator.class.isInstance(instantiator) ? (StdValueInstantiator)StdValueInstantiator.class.cast(instantiator) : null;
                this.properties = this.instantiator == null || this.instantiator.getFromObjectArguments(config) == null ? new SettableBeanProperty[]{} : (SettableBeanProperty[])this.instantiator.getFromObjectArguments(config).clone();
            }

            void replacePropertyIfNeeded(BeanDeserializerBuilder builder, SettableBeanProperty property) {
                builder.addOrReplaceProperty(property, false);
                if (!CreatorProperty.class.isInstance(property)) {
                    return;
                }
                this.properties[((CreatorProperty)property).getCreatorIndex()] = property;
            }

            BeanDeserializerBuilder conclude(BeanDeserializerBuilder builder) {
                if (this.instantiator == null) {
                    return builder;
                }
                ReflectionUtils.setField(CONSTRUCTOR_ARGS_FIELD, this.instantiator, this.properties);
                builder.setValueInstantiator(this.instantiator);
                return builder;
            }

            static {
                ReflectionUtils.makeAccessible(CONSTRUCTOR_ARGS_FIELD);
            }
        }
    }

    private static class RepositoryInvokingDeserializer
    extends StdScalarDeserializer<Object> {
        private static final long serialVersionUID = -3033458643050330913L;
        private final RepositoryInvoker invoker;

        private RepositoryInvokingDeserializer(RepositoryInvokerFactory factory2, PersistentProperty<?> property) {
            super(property.getActualType());
            this.invoker = factory2.getInvokerFor(this._valueClass);
        }

        @Override
        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Object id = p.getCurrentToken().isNumeric() ? Long.valueOf(p.getValueAsLong()) : p.getValueAsString();
            return this.invoker.invokeFindById(id).orElse(null);
        }
    }

    static class CollectionValueInstantiator
    extends ValueInstantiator {
        private final TypeInformation<?> property;

        public CollectionValueInstantiator(TypeInformation<?> property) {
            Assert.notNull(property, "Property must not be null");
            Assert.isTrue(property.isCollectionLike() || property.isMap(), "Property must be a collection or map property");
            this.property = property;
        }

        @Override
        public String getValueTypeDesc() {
            return this.property.getType().getName();
        }

        @Override
        public Object createUsingDefault(DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Class<?> collectionOrMapType = this.property.getType();
            return this.property.isMap() ? CollectionFactory.createMap(collectionOrMapType, 0) : CollectionFactory.createCollection(collectionOrMapType, 0);
        }
    }

    static class ProjectionResourceContent {
        private final Object projection;
        private final Class<?> projectionInterface;

        public ProjectionResourceContent(Object projection, Class<?> projectionInterface) {
            this.projection = projection;
            this.projectionInterface = projectionInterface;
        }

        public Object getProjection() {
            return this.projection;
        }

        public Class<?> getProjectionInterface() {
            return this.projectionInterface;
        }
    }

    static class ProjectionResource
    extends EntityModel<ProjectionResourceContent> {
        ProjectionResource(TargetAware projection, Iterable<Link> links) {
            super(new ProjectionResourceContent(projection, projection.getClass().getInterfaces()[0]), links);
        }
    }

    public static class UriStringDeserializer
    extends StdDeserializer<Object> {
        private static final long serialVersionUID = -2175900204153350125L;
        private static final String UNEXPECTED_VALUE = "Expected URI cause property %s points to the managed domain type";
        private final Class<?> type;
        private final UriToEntityConverter converter;

        public UriStringDeserializer(Class<?> type, UriToEntityConverter converter) {
            super(type);
            this.type = type;
            this.converter = converter;
        }

        @Override
        public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String source2 = jp.getValueAsString();
            if (!StringUtils.hasText(source2)) {
                return null;
            }
            try {
                URI uri = UriTemplate.of(source2).expand(new Object[0]);
                TypeDescriptor typeDescriptor = TypeDescriptor.valueOf(this.type);
                return this.converter.convert(uri, URI_DESCRIPTOR, typeDescriptor);
            }
            catch (IllegalArgumentException o_O) {
                throw ctxt.weirdStringException(source2, URI.class, String.format(UNEXPECTED_VALUE, this.type));
            }
        }

        @Override
        public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            return this.deserialize(jp, ctxt);
        }
    }
}

