/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.data.rest.webmvc.json.patch.LateObjectEvaluator;
import org.springframework.data.rest.webmvc.json.patch.PatchException;
import org.springframework.util.Assert;

class JsonLateObjectEvaluator
implements LateObjectEvaluator {
    private final ObjectMapper mapper;
    private final JsonNode node;

    public JsonLateObjectEvaluator(ObjectMapper mapper, JsonNode node) {
        Assert.notNull((Object)mapper, "ObjectMapper must not be null");
        Assert.notNull((Object)node, "JsonNode must not be null");
        this.mapper = mapper;
        this.node = node;
    }

    @Override
    public Object evaluate(Class<?> type) {
        try {
            return this.mapper.readValue(this.node.traverse(this.mapper.getFactory().getCodec()), type);
        }
        catch (Exception o_O) {
            throw new PatchException(String.format("Could not read %s into %s", this.node, type), o_O);
        }
    }
}

