/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import java.util.Optional;
import java.util.function.BiFunction;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.rest.webmvc.json.patch.BindContext;
import org.springframework.data.rest.webmvc.json.patch.PatchException;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

class JsonPointerMapping {
    private final BiFunction<String, Class<?>, Optional<String>> reader;
    private final BiFunction<String, Class<?>, Optional<String>> writer;

    public JsonPointerMapping(BindContext context) {
        this.reader = context::getReadableProperty;
        this.writer = context::getWritableProperty;
    }

    public JsonPointerMapping(BiFunction<String, Class<?>, Optional<String>> reader, BiFunction<String, Class<?>, Optional<String>> writer) {
        this.reader = reader;
        this.writer = writer;
    }

    public String forRead(String pointer, Class<?> type) {
        return this.verify(pointer, type, this.reader, "readable");
    }

    public String forWrite(String pointer, Class<?> type) {
        return this.verify(pointer, type, this.writer, "writable");
    }

    private String verify(String pointer, Class<?> type, BiFunction<String, Class<?>, Optional<String>> filter2, String qualifier) {
        String[] strings = pointer.split("/");
        if (strings.length == 0) {
            return pointer;
        }
        PropertyPath base = null;
        StringBuilder result = new StringBuilder();
        TypeInformation<?> currentType = ClassTypeInformation.from(type);
        for (int i2 = 0; i2 < strings.length; ++i2) {
            String segment = strings[i2];
            if (!StringUtils.hasText(segment)) continue;
            if (currentType != null && currentType.isMap()) {
                result.append("/").append(segment);
                currentType = currentType.getActualType();
                continue;
            }
            if (segment.equals("-") || segment.matches("\\d+")) {
                result.append("/").append(segment);
                currentType = currentType.getActualType();
                continue;
            }
            ClassTypeInformation<?> rejectType = currentType;
            String property = (i2 == strings.length - 1 ? filter2 : this.reader).apply(segment, currentType.getType()).orElseThrow(() -> JsonPointerMapping.reject(segment, rejectType, pointer, qualifier));
            try {
                base = base == null ? PropertyPath.from(property, type) : base.nested(segment);
            }
            catch (PropertyReferenceException o_O) {
                throw JsonPointerMapping.reject(segment, rejectType, pointer, qualifier);
            }
            currentType = base.getTypeInformation();
            result.append("/").append(property);
        }
        return result.toString();
    }

    private static PatchException reject(String segment, TypeInformation<?> type, String pointer, String qualifier) {
        return new PatchException(String.format("Couldn't find %s property for pointer segment %s on %s in %s", qualifier, segment, type.getType(), pointer));
    }
}

