/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.data.rest.webmvc.support.ConstraintViolationMessage;

public class ConstraintViolationExceptionMessage {
    private final ConstraintViolationException cve;
    private final List<ConstraintViolationMessage> messages = new ArrayList<ConstraintViolationMessage>();

    public ConstraintViolationExceptionMessage(ConstraintViolationException cve, MessageSource msgSrc, Locale locale) {
        this.cve = cve;
        for (ConstraintViolation<?> cv : cve.getConstraintViolations()) {
            this.messages.add(new ConstraintViolationMessage(cv, msgSrc, locale));
        }
    }

    @JsonProperty(value="cause")
    public String getCause() {
        return this.cve.getMessage();
    }

    @JsonProperty(value="messages")
    public List<ConstraintViolationMessage> getMessages() {
        return this.messages;
    }
}

