/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.support.DefaultedPageable;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class DefaultedPageableHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final PageableHandlerMethodArgumentResolver resolver;

    public DefaultedPageableHandlerMethodArgumentResolver(PageableHandlerMethodArgumentResolver resolver) {
        Assert.notNull((Object)resolver, "PageableHandlerMethodArgumentResolver must not be null");
        this.resolver = resolver;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Pageable pageable = this.resolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        return new DefaultedPageable(pageable, this.resolver.isFallbackPageable(pageable));
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return DefaultedPageable.class.isAssignableFrom(parameter.getParameterType());
    }
}

