/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.util.Objects;
import java.util.Optional;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.support.ETagDoesntMatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ETag {
    public static final ETag NO_ETAG = new ETag(null);
    private final String value;

    private ETag(String value) {
        this.value = StringUtils.trimTrailingCharacter(StringUtils.trimLeadingCharacter(value, '\"'), '\"');
    }

    public static ETag from(String value) {
        return new ETag(value);
    }

    public static ETag from(Optional<String> value) {
        return value.map(ETag::new).orElse(NO_ETAG);
    }

    public static ETag from(PersistentEntityResource resource) {
        Assert.notNull((Object)resource, "PersistentEntityResource must not be null");
        return ETag.from(resource.getPersistentEntity(), resource.getTarget());
    }

    public static ETag from(PersistentEntity<?, ? extends PersistentProperty<?>> entity, Object bean2) {
        return ETag.getVersionInformation(entity, bean2).map(ETag::from).orElse(NO_ETAG);
    }

    public void verify(PersistentEntity<?, ?> entity, Object target) {
        if (this == NO_ETAG || target == null) {
            return;
        }
        if (!this.equals(ETag.from(entity, target))) {
            throw new ETagDoesntMatchException(target, this);
        }
    }

    public boolean matches(PersistentEntity<?, ?> entity, Object target) {
        if (this == NO_ETAG || target == null) {
            return false;
        }
        return this.equals(ETag.from(entity, target));
    }

    public HttpHeaders addTo(HttpHeaders headers) {
        Assert.notNull((Object)headers, "HttpHeaders must not be null");
        String stringValue = this.toString();
        if (stringValue == null) {
            return headers;
        }
        headers.setETag(stringValue);
        return headers;
    }

    public String toString() {
        return this.value == null ? null : "\"".concat(this.value).concat("\"");
    }

    private static Optional<String> getVersionInformation(PersistentEntity<?, ? extends PersistentProperty<?>> entity, Object bean2) {
        Assert.notNull(entity, "PersistentEntity must not be null");
        Assert.notNull(bean2, "Target bean must not be null");
        PersistentPropertyAccessor<Object> accessor = entity.getPropertyAccessor(bean2);
        return Optional.ofNullable(entity.getVersionProperty()).map(it -> accessor.getProperty((PersistentProperty<?>)it)).map(Object::toString);
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ETag)) {
            return false;
        }
        ETag other = (ETag)o;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

