/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public enum HttpMethodHandlerMethodArgumentResolver implements HandlerMethodArgumentResolver
{
    INSTANCE;


    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return HttpMethod.class.equals(parameter.getParameterType());
    }

    @Override
    public HttpMethod resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        HttpServletRequest httpServletRequest = webRequest.getNativeRequest(HttpServletRequest.class);
        return HttpMethod.valueOf(httpServletRequest.getMethod().trim().toUpperCase());
    }
}

