/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.util.function.Function;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.data.rest.webmvc.support.DefaultExcerptProjector;
import org.springframework.data.rest.webmvc.support.Projector;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PersistentEntityProjector
extends DefaultExcerptProjector
implements Projector {
    private final ProjectionDefinitions definitions;
    private final ProjectionFactory factory;
    private final String projection;

    public PersistentEntityProjector(ProjectionDefinitions projectionDefinitions, ProjectionFactory factory2, String projection, ResourceMappings mappings) {
        super(factory2, mappings);
        Assert.notNull((Object)projectionDefinitions, "ProjectionDefinitions must not be null");
        Assert.notNull((Object)factory2, "ProjectionFactory must not be null");
        this.factory = factory2;
        this.definitions = projectionDefinitions;
        this.projection = projection;
    }

    @Override
    public Object project(Object source2) {
        return this.projectWithDefault(source2, Function.identity());
    }

    @Override
    public Object projectExcerpt(Object source2) {
        return this.projectWithDefault(source2, x$0 -> PersistentEntityProjector.super.projectExcerpt(x$0));
    }

    private Object projectWithDefault(Object source2, Function<Object, Object> converter) {
        Assert.notNull(source2, "Projection source must not be null");
        Assert.notNull(converter, "Converter must not be null");
        if (!StringUtils.hasText(this.projection)) {
            return converter.apply(source2);
        }
        Class<?> projectionType = this.definitions.getProjectionType(source2.getClass(), this.projection);
        return projectionType == null ? converter.apply(source2) : this.factory.createProjection(projectionType, source2);
    }
}

